/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.RegionInfo;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.TimeZoneRegionResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TimezoneRegionsResponseProvider
implements CustomerResponseProvider<List<TimeZoneRegionResponse>> {
    private final UserFactory userFactory;
    private final TimeZoneService timeZoneService;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public TimezoneRegionsResponseProvider(UserFactory userFactory, TimeZoneService timeZoneService, JiraAuthenticationContext jiraAuthenticationContext) {
        this.userFactory = userFactory;
        this.timeZoneService = timeZoneService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<TimeZoneRegionResponse>> getResponse(ModelsRequest ctx) {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).map(user -> this.getTimeZoneRegions((JiraServiceContext)new JiraServiceContextImpl(user.forJIRA())));
    }

    private List<TimeZoneRegionResponse> getTimeZoneRegions(JiraServiceContext serviceContext) {
        ArrayList<TimeZoneRegionResponse> regions = new ArrayList<TimeZoneRegionResponse>();
        regions.add(this.getDefaultTimeZoneRegionResponse(serviceContext));
        regions.addAll(this.getJiraTimeZoneRegions(serviceContext));
        return regions;
    }

    private List<TimeZoneRegionResponse> getJiraTimeZoneRegions(JiraServiceContext serviceContext) {
        return this.timeZoneService.getTimeZoneRegions(serviceContext).stream().map(this::toTimeZoneRegionResponse).collect(Collectors.toList());
    }

    private TimeZoneRegionResponse getDefaultTimeZoneRegionResponse(JiraServiceContext serviceContext) {
        return new TimeZoneRegionResponse("JIRA", this.jiraAuthenticationContext.getI18nHelper().getText("sd.common.words.default"));
    }

    private TimeZoneRegionResponse toTimeZoneRegionResponse(RegionInfo regionInfo) {
        return new TimeZoneRegionResponse(regionInfo.getKey(), regionInfo.getDisplayName());
    }
}

