/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.response.PortalOverviewResponse;
import com.atlassian.servicedesk.internal.rest.ImageResource;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalsResponseProvider
implements CustomerResponseProvider<List<PortalOverviewResponse>> {
    private final UserFactory userFactory;
    private final InternalPortalService internalPortalService;
    private final CustomerUrlUtil customerUrlUtil;
    private final RichTextRenderer richTextRenderer;

    @Autowired
    public PortalsResponseProvider(UserFactory userFactory, InternalPortalService internalPortalService, CustomerUrlUtil customerUrlUtil, RichTextRenderer richTextRenderer) {
        this.userFactory = userFactory;
        this.internalPortalService = internalPortalService;
        this.customerUrlUtil = customerUrlUtil;
        this.richTextRenderer = richTextRenderer;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, List<PortalOverviewResponse>> getResponse(ModelsRequest ctx) {
        return StepsConverters.newerEither((Either)this.userFactory.getCheckedUser()).map(this.internalPortalService::getCustomerVisiblePortals).map(portals -> portals.stream().map(this::toPortalOverviewResponse).collect(Collectors.toList()));
    }

    private PortalOverviewResponse toPortalOverviewResponse(Portal portal) {
        return new PortalOverviewResponse(String.valueOf(portal.getId()), this.internalPortalService.getPortalKey(portal), portal.getName(), this.richTextRenderer.renderWiki(portal.getDescription(), new RenderOption[0]), this.customerUrlUtil.getPortalUrlSimple(portal), (String)this.getLogoUrl(portal).getOrNull());
    }

    private Option<String> getLogoUrl(Portal portal) {
        return this.internalPortalService.getLogoId(portal).map(ImageResource::imagePath).map(imgPath -> this.customerUrlUtil.getRestUrl() + imgPath);
    }
}

