/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.requesttype.RequestTypeGroup;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.api.requesttype.group.RequestTypeGroupService;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.feature.announcement.Announcement;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.KbsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.list.RequestListProvider;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.requesttypegroup.RequestTypeGroupJSON;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.rest.responses.AnnouncementResponse;
import com.atlassian.servicedesk.internal.rest.responses.RequestTypeBean;
import com.atlassian.servicedesk.internal.rest.responses.portal.PortalResponse;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import io.atlassian.fugue.Option;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalResponseProviderHelper {
    private final AnnouncementService announcementService;
    private final KbsResponseProvider kbsResponseProvider;
    private final RequestTypeGroupService requestTypeGroupService;
    private final CustomerUrlUtil customerUrlUtil;
    private final RequestListProvider requestListProvider;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final InternalPortalService internalPortalService;
    private final RichTextRenderer richTextRenderer;
    private final RequestTypeInternalService requestTypeInternalService;
    private final FeatureManager featureManager;

    @Autowired
    public PortalResponseProviderHelper(AnnouncementService announcementService, KbsResponseProvider kbsResponseProvider, RequestTypeGroupService requestTypeGroupService, CustomerUrlUtil customerUrlUtil, RequestListProvider requestListProvider, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, InternalPortalService internalPortalService, RichTextRenderer richTextRenderer, RequestTypeInternalService requestTypeInternalService, FeatureManager featureManager) {
        this.announcementService = announcementService;
        this.kbsResponseProvider = kbsResponseProvider;
        this.requestTypeGroupService = requestTypeGroupService;
        this.customerUrlUtil = customerUrlUtil;
        this.requestListProvider = requestListProvider;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.internalPortalService = internalPortalService;
        this.richTextRenderer = richTextRenderer;
        this.requestTypeInternalService = requestTypeInternalService;
        this.featureManager = featureManager;
    }

    public PortalResponse toResponse(CheckedUser user, Portal portal, Project project, ServiceDesk serviceDesk, List<RequestType> requestTypes, Announcement announcement, List<String> expand) throws SearchException {
        PortalResponse portalResponse = new PortalResponse();
        portalResponse.setId(String.valueOf(portal.getId()));
        portalResponse.setPortalBaseUrl(this.customerUrlUtil.getPortalUrlSimple(portal));
        portalResponse.setKey(this.internalPortalService.getPortalKey(portal));
        portalResponse.setProjectId(project.getId());
        portalResponse.setServiceDeskId(Long.valueOf(serviceDesk.getId()));
        portalResponse.setName(portal.getName());
        portalResponse.setDescription(this.richTextRenderer.renderCustomerWiki(portal.getDescription(), (Option<CheckedUser>)Option.some((Object)user), RenderOption.OPEN_LINKS_IN_NEW_TAB));
        portalResponse.setCreatePermission(this.serviceDeskLicenseAndPermissionService.canCreateRequest((SDUser)user, project));
        portalResponse.setAnnouncement(this.getAnnouncementResponse(announcement, this.richTextRenderer, user, portal, project));
        List<Portal> visiblePortals = this.internalPortalService.getCustomerVisiblePortals(user);
        long openRequestCount = visiblePortals.stream().anyMatch(p -> p.getId() == portal.getId()) ? 0L : this.requestListProvider.getOpenRequestsCountForUser(user, (Option<Portal>)Option.some((Object)portal));
        portalResponse.setOpenRequestCount(openRequestCount);
        portalResponse.setOnlyPortal(visiblePortals.size() == 1);
        this.processExpandList(portalResponse, expand, user, project, requestTypes, portal);
        return portalResponse;
    }

    private AnnouncementResponse getAnnouncementResponse(Announcement announcement, RichTextRenderer richTextRenderer, CheckedUser user, Portal portal, Project project) {
        String announcementHeader = announcement.getHeaderAsText();
        String announcementMessage = announcement.getMessageAsText();
        boolean canEditAnnouncement = this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_PROJECT_ANNOUNCEMENT) && this.announcementService.canEditPortalAnnouncement(user, portal, project);
        return new AnnouncementResponse(announcementHeader, richTextRenderer.renderCustomerWiki(announcementHeader, (Option<CheckedUser>)Option.some((Object)user), RenderOption.OPEN_LINKS_IN_NEW_TAB), announcementMessage, richTextRenderer.renderCustomerWiki(announcementMessage, (Option<CheckedUser>)Option.some((Object)user), RenderOption.OPEN_LINKS_IN_NEW_TAB), canEditAnnouncement, (Option<Portal>)Option.some((Object)portal));
    }

    private void processExpandList(PortalResponse portalResponse, List<String> expandList, CheckedUser user, Project project, List<RequestType> requestTypes, Portal portal) {
        Iterator<String> iterator = expandList.iterator();
        while (iterator.hasNext()) {
            String expandThis;
            switch (expandThis = iterator.next()) {
                case "kbs": {
                    portalResponse.setKbs(this.kbsResponseProvider.getResponse(user, project, (Option<RequestType>)Option.none()));
                    break;
                }
                case "orderMapping": {
                    portalResponse.setOrderMapping((Map)this.requestTypeGroupService.getGroupToRequestTypeOrderMapping(user, project).getOrNull());
                    break;
                }
                case "reqTypes": {
                    portalResponse.setReqTypes(requestTypes.stream().map(r -> new RequestTypeBean((RequestType)r, this.requestTypeInternalService.getRequestTypeKey(r), user, this.richTextRenderer)).collect(Collectors.toList()));
                    break;
                }
                case "reqGroups": {
                    this.requestTypeGroupService.getGroups(user.forJIRA(), project, portal).forEach(groups -> portalResponse.setReqGroups(this.getGroupsResponse((List<RequestTypeGroup>)groups, portalResponse.getReqTypes())));
                    break;
                }
            }
        }
    }

    private List<RequestTypeGroupJSON> getGroupsResponse(List<RequestTypeGroup> groups, List<RequestTypeBean> requestTypeBeans) {
        List filteredGroups = groups.stream().filter(g -> requestTypeBeans.stream().anyMatch(b -> b.getGroups().contains(g.getId()))).collect(Collectors.toList());
        return filteredGroups.stream().map(RequestTypeGroupJSON::new).collect(Collectors.toList());
    }
}

