/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.feature.announcement.Announcement;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalResponseProviderHelper;
import com.atlassian.servicedesk.internal.feature.jira.project.ServiceDeskProjectService;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.portal.PortalResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortalResponseProvider
implements CustomerResponseProvider<PortalResponse> {
    private final UserFactory userFactory;
    private final ServiceDeskProjectService serviceDeskProjectService;
    private final RequestTypeInternalService requestTypeInternalService;
    private final InternalServiceDeskService internalServiceDeskService;
    private final AnnouncementService announcementService;
    private final InternalPortalService internalPortalService;
    private final ErrorResultHelper errorResultHelper;
    private final PortalResponseProviderHelper portalResponseProviderHelper;

    @Autowired
    public PortalResponseProvider(UserFactory userFactory, ServiceDeskProjectService serviceDeskProjectService, RequestTypeInternalService requestTypeInternalService, InternalServiceDeskService internalServiceDeskService, AnnouncementService announcementService, InternalPortalService internalPortalService, ErrorResultHelper errorResultHelper, PortalResponseProviderHelper portalResponseProviderHelper) {
        this.userFactory = userFactory;
        this.serviceDeskProjectService = serviceDeskProjectService;
        this.requestTypeInternalService = requestTypeInternalService;
        this.internalServiceDeskService = internalServiceDeskService;
        this.announcementService = announcementService;
        this.internalPortalService = internalPortalService;
        this.errorResultHelper = errorResultHelper;
        this.portalResponseProviderHelper = portalResponseProviderHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, PortalResponse> getResponse(ModelsRequest ctx) {
        return Steps.begin(this.prepareWrapper(ctx)).then(wrapper -> this.requestTypeInternalService.getAllValidNonHiddenRequestTypes(wrapper.getUser(), wrapper.getProject(), wrapper.getPortal())).then((wrapper, requestTypes) -> this.announcementService.getPortalAnnouncement(wrapper.getUser(), wrapper.getProject(), wrapper.getPortal().getId())).then((wrapper, requestTypes, announcement) -> this.getPortalResponse(wrapper.getUser(), wrapper.getPortal(), wrapper.getProject(), wrapper.getServiceDesk(), (List<RequestType>)requestTypes, (Announcement)announcement, ctx.getOptions().getPortal().getExpand())).yield((wrapper, requestTypes, announcement, portalResponse) -> portalResponse);
    }

    private io.atlassian.fugue.Either<AnError, PortalResponse> getPortalResponse(CheckedUser user, Portal portal, Project project, ServiceDesk serviceDesk, List<RequestType> requestTypes, Announcement announcement, List<String> expand) {
        try {
            PortalResponse portalResponse = this.portalResponseProviderHelper.toResponse(user, portal, project, serviceDesk, requestTypes, announcement, expand);
            return io.atlassian.fugue.Either.right((Object)portalResponse);
        }
        catch (SearchException e) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.servicedesk.enable.unknown.failure", new Object[0]).build());
        }
    }

    private io.atlassian.fugue.Either<AnError, Wrapper> prepareWrapper(ModelsRequest ctx) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(user -> this.internalPortalService.getPortalById((CheckedUser)user, ctx.getOptions().getPortalId())).then((user, portal) -> this.serviceDeskProjectService.getProjectById((CheckedUser)user, this.internalPortalService.getProjectIdForPortal((Portal)portal))).then((user, portal, project) -> this.internalServiceDeskService.getServiceDeskForProject(user, project, true)).yield((user, portal, project, serviceDesk) -> new Wrapper((CheckedUser)user, (Portal)portal, (ServiceDesk)serviceDesk, (Project)project));
    }

    private class Wrapper {
        CheckedUser user;
        Portal portal;
        ServiceDesk serviceDesk;
        Project project;

        public Wrapper(CheckedUser user, Portal portal, ServiceDesk serviceDesk, Project project) {
            this.user = user;
            this.portal = portal;
            this.serviceDesk = serviceDesk;
            this.project = project;
        }

        public CheckedUser getUser() {
            return this.user;
        }

        public Portal getPortal() {
            return this.portal;
        }

        public ServiceDesk getServiceDesk() {
            return this.serviceDesk;
        }

        public Project getProject() {
            return this.project;
        }
    }
}

