/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.pocketknife.annotations.lucene.LuceneUsage;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.errors.ServiceDeskHttpError;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.response.PortalOverviewResponse;
import com.atlassian.servicedesk.internal.rest.ImageResource;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.utils.Convert;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PopularPortalResponseProvider
implements CustomerResponseProvider<List<PortalOverviewResponse>> {
    private static final Logger log = LoggerFactory.getLogger(PopularPortalResponseProvider.class);
    private static final int MAX_NUMBER_OF_ISSUES_TO_FIND = 200;
    private static final int MAX_NUMBER_OF_PORTALS_TO_FIND = 6;
    private final SearchProvider searchProvider;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final InternalPortalService internalPortalService;
    private final CustomerUrlUtil customerUrlUtil;
    private final UserFactory userFactory;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public PopularPortalResponseProvider(SearchProvider searchProvider, VpOriginCustomFieldService vpOriginCustomFieldService, InternalPortalService internalPortalService, CustomerUrlUtil customerUrlUtil, UserFactory userFactory, WebResourceUrlProvider webResourceUrlProvider, ErrorResultHelper errorResultHelper) {
        this.searchProvider = searchProvider;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.internalPortalService = internalPortalService;
        this.customerUrlUtil = customerUrlUtil;
        this.userFactory = userFactory;
        this.webResourceUrlProvider = webResourceUrlProvider;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    public io.atlassian.fugue.Either<AnError, List<PortalOverviewResponse>> getResponse(ModelsRequest ctx) {
        io.atlassian.fugue.Either userEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (userEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)userEither.left().get());
        }
        CheckedUser checkedUser = (CheckedUser)userEither.right().get();
        List<Portal> customerVisiblePortals = this.internalPortalService.getCustomerVisiblePortals(checkedUser);
        if (CollectionUtils.isEmpty(customerVisiblePortals)) {
            return io.atlassian.fugue.Either.right(Collections.emptyList());
        }
        ServiceDeskHitCollector collector = new ServiceDeskHitCollector();
        try {
            this.searchProvider.searchAndSortOverrideSecurity(this.buildJqlQuery(customerVisiblePortals), (ApplicationUser)null, (Collector)collector, PagerFilter.newPageAlignedFilter((int)0, (int)200));
        }
        catch (SearchException e) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.internalServiceError500("sd.issue.search.exception", new Object[]{e}).build());
        }
        List<Map.Entry<String, Integer>> projectIdCounts = collector.getSortedServiceDeskCount();
        ArrayList portals = Lists.newArrayList();
        for (Map.Entry<String, Integer> projectIdCount : projectIdCounts) {
            String projectIdAsString = projectIdCount.getKey();
            try {
                Portal portal2;
                Long projectId = Long.parseLong(projectIdAsString);
                Option portalOption = Iterables.findFirst(customerVisiblePortals, portal -> this.internalPortalService.toPortalInternal((Portal)portal).getProjectId() == projectId.longValue());
                if (portalOption.isEmpty()) {
                    log.error("JQL search for popular portals found project " + projectId + " that we were not looking for");
                }
                if (!portals.contains(portal2 = (Portal)portalOption.get())) {
                    portals.add(portal2);
                }
                if (portals.size() < 6) continue;
                break;
            }
            catch (NumberFormatException ex) {
                log.error("Project ID " + projectIdAsString + " is not a number");
            }
        }
        List popularPortalResponses = Lists.transform((List)portals, (Function)new Function<Portal, PortalOverviewResponse>(){

            public PortalOverviewResponse apply(Portal portal) {
                String logoUrl = (String)PopularPortalResponseProvider.this.internalPortalService.toPortalInternal(portal).getLogoId().map(logoId -> PopularPortalResponseProvider.this.customerUrlUtil.getRestUrl(true) + ImageResource.imagePath(logoId)).getOrNull();
                return new PortalOverviewResponse(Integer.toString(portal.getId()), PopularPortalResponseProvider.this.internalPortalService.toPortalInternal(portal).getKey(), portal.getName(), portal.getDescription(), PopularPortalResponseProvider.this.customerUrlUtil.getPortalUrl(portal, "", Maps.newHashMap(), true), logoUrl);
            }
        });
        return io.atlassian.fugue.Either.right((Object)popularPortalResponses);
    }

    private Query buildJqlQuery(List<Portal> customerVisiblePortals) {
        CustomField vpOriginCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        List projectIds = Lists.transform(customerVisiblePortals, (Function)new Function<Portal, Long>(){

            public Long apply(Portal portal) {
                return PopularPortalResponseProvider.this.internalPortalService.toPortalInternal(portal).getProjectId();
            }
        });
        return queryBuilder.where().project(projectIds.toArray(new Long[projectIds.size()])).and().customField(vpOriginCustomField.getIdAsLong()).isNotEmpty().endWhere().orderBy().createdDate(SortOrder.DESC).endOrderBy().buildQuery();
    }

    AnError toAnError(ServiceDeskHttpError error) {
        return Convert.toAnError(error, this.errorResultHelper);
    }

    @VisibleForTesting
    @LuceneUsage(type=LuceneUsage.LuceneUsageType.IssueAggregation)
    static class ServiceDeskHitCollector
    extends Collector {
        private final FieldSelector projectFieldSelector;
        private final String projectIdField;
        @TenantAware(value=TenancyScope.TENANTED)
        private final Map<String, Integer> projectIdCount = Maps.newHashMap();
        private IndexReader indexReader;

        private ServiceDeskHitCollector() {
            this.projectIdField = "projid";
            this.projectFieldSelector = new SingleFieldSelector(this.projectIdField);
        }

        public void setScorer(Scorer scorer) {
        }

        public void collect(int doc) {
            try {
                Document document = this.indexReader.document(doc, this.projectFieldSelector);
                String projectId = document.get(this.projectIdField);
                if (projectId != null && StringUtils.isNotBlank((String)projectId)) {
                    if (this.projectIdCount.containsKey(projectId)) {
                        this.projectIdCount.put(projectId, this.projectIdCount.get(projectId) + 1);
                    } else {
                        this.projectIdCount.put(projectId, 1);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void setNextReader(IndexReader reader, int docBase) {
            this.indexReader = reader;
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        public List<Map.Entry<String, Integer>> getSortedServiceDeskCount() {
            ArrayList list = Lists.newArrayList(this.projectIdCount.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return Long.compare(o2.getValue().intValue(), o1.getValue().intValue());
                }
            });
            return list;
        }

        private static class SingleFieldSelector
        implements FieldSelector {
            private final String fieldName;

            private SingleFieldSelector(@Nonnull String fieldName) {
                this.fieldName = fieldName;
            }

            public FieldSelectorResult accept(String fieldName) {
                if (this.fieldName.equals(fieldName)) {
                    return FieldSelectorResult.LOAD_AND_BREAK;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        }
    }
}

