/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.customer.PortalLoginService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.user.signup.ServiceDeskSignupValidator;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.login.LoginResponse;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginResponseProvider
implements CustomerResponseProvider<LoginResponse> {
    private static final String LOGIN_PATH = "/user/login";
    private final PortalLoginService portalLoginService;
    private final CustomerUrlUtil customerUrlUtil;
    private final ServiceDeskSignupValidator sdSignUpValidator;
    private final PortalInternalManager portalManager;
    private final InternalServiceDeskProjectManager projectManager;
    private final ServiceDeskInternalManager serviceDeskManager;

    @Autowired
    public LoginResponseProvider(PortalLoginService portalLoginService, CustomerUrlUtil customerUrlUtil, ServiceDeskSignupValidator sdSignUpValidator, PortalInternalManager portalManager, InternalServiceDeskProjectManager projectManager, ServiceDeskInternalManager serviceDeskManager) {
        this.portalLoginService = portalLoginService;
        this.customerUrlUtil = customerUrlUtil;
        this.sdSignUpValidator = sdSignUpValidator;
        this.portalManager = portalManager;
        this.projectManager = projectManager;
        this.serviceDeskManager = serviceDeskManager;
    }

    @Override
    public Either<AnError, LoginResponse> getResponse(ModelsRequest ctx) {
        if (ctx.getOptions().getPortalId() < 0L) {
            return this.getLoginResponseNoPortalProvided();
        }
        return this.getLoginReponseForPortal(ctx.getOptions().getPortalId());
    }

    private Either<AnError, LoginResponse> getLoginReponseForPortal(long portalId) {
        boolean includeDisabled = false;
        return Steps.begin(this.portalManager.getPortalById(portalId)).then(portal -> this.projectManager.getProject(Long.valueOf(portal.getProjectId()))).then((portal, project) -> this.serviceDeskManager.getServiceDesk((Project)project, includeDisabled)).yield((portal, project, serviceDesk) -> new LoginResponse(this.portalLoginService.getLoginProperties(), this.customerUrlUtil.getPortalUrl((Portal)portal, LOGIN_PATH), this.portalLoginService.canResetPassword(), this.portalLoginService.getGoogleAppsState(), this.sdSignUpValidator.isSignUpSupportedFromPortal((ServiceDesk)serviceDesk, (Project)project)));
    }

    private Either<AnError, LoginResponse> getLoginResponseNoPortalProvided() {
        return Either.right((Object)new LoginResponse(this.portalLoginService.getLoginProperties(), this.customerUrlUtil.getUrl(LOGIN_PATH), this.portalLoginService.canResetPassword(), this.portalLoginService.getGoogleAppsState(), this.sdSignUpValidator.isSignupSupportedFromHelpCenter()));
    }
}

