/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseInternalService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.rest.responses.kb.ConfluenceKBLinkResponse;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.KbsResponseProvider;
import com.atlassian.servicedesk.internal.rest.responses.kb.KBResponse;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Suppliers;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KbsResponseProviderImpl
implements KbsResponseProvider {
    private final ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService;
    private final ServiceDeskAppLinkService serviceDeskAppLinkService;

    @Autowired
    public KbsResponseProviderImpl(ConfluenceKnowledgeBaseInternalService confluenceKnowledgeBaseInternalService, ServiceDeskAppLinkService serviceDeskAppLinkService) {
        this.confluenceKnowledgeBaseInternalService = confluenceKnowledgeBaseInternalService;
        this.serviceDeskAppLinkService = serviceDeskAppLinkService;
    }

    @Override
    public KBResponse getResponse(CheckedUser user, Project project, Option<RequestType> requestTypeOpt) {
        return (KBResponse)Steps.begin((Option)this.confluenceKnowledgeBaseInternalService.getKBLink(user, project).toOption()).then(kbLink -> this.serviceDeskAppLinkService.getAllApplicationLinksForType(user, project, ConfluenceApplicationType.class).toOption()).then((kbLink, links) -> (Option)requestTypeOpt.fold(() -> this.getResponseFromKBLink((ConfluenceKnowledgeBaseLink)kbLink, project), rt -> this.getResponseFromKBLink((ConfluenceKnowledgeBaseLink)kbLink, user, project, (RequestType)rt, (List<ApplicationLink>)links))).yield((kbLink, links, response) -> response).getOrElse((Object)new KBResponse());
    }

    private Option<KBResponse> getResponseFromKBLink(ConfluenceKnowledgeBaseLink kbLink, Project project) {
        return Option.some((Object)new KBResponse(true, ConfluenceKBLinkResponse.toConfluenceKBLinkResponse((ConfluenceKnowledgeBaseLink)kbLink), Lists.newArrayList(), project.getKey(), new Long(kbLink.getServiceDeskId())));
    }

    private Option<KBResponse> getResponseFromKBLink(ConfluenceKnowledgeBaseLink kbLink, CheckedUser user, Project project, RequestType requestType, List<ApplicationLink> links) {
        return Steps.begin(this.isValidAppLinkWithSearchEnabled(kbLink, user, project, requestType, links)).then(isValid -> this.confluenceKnowledgeBaseInternalService.getAllLabelsForRequestType(requestType).toOption()).yield((isValid, labels) -> new KBResponse((Boolean)isValid, ConfluenceKBLinkResponse.toConfluenceKBLinkResponse((ConfluenceKnowledgeBaseLink)kbLink), (List<String>)labels, project.getKey(), new Long(kbLink.getServiceDeskId())));
    }

    private Option<Boolean> isValidAppLinkWithSearchEnabled(ConfluenceKnowledgeBaseLink kbLink, CheckedUser user, Project project, RequestType requestType, List<ApplicationLink> links) {
        if (this.isSearchEnabled(user, project, requestType).booleanValue() && this.isAppLinkValid(kbLink, links).booleanValue()) {
            return Option.some((Object)true);
        }
        return Option.none();
    }

    private Boolean isSearchEnabled(CheckedUser user, Project project, RequestType requestType) {
        return (Boolean)this.confluenceKnowledgeBaseInternalService.getSearchEnabled(project, user, requestType.getId()).map(kbEnableResponse -> kbEnableResponse.getEnabled()).getOr(Suppliers.alwaysFalse());
    }

    private Boolean isAppLinkValid(ConfluenceKnowledgeBaseLink kbLink, List<ApplicationLink> links) {
        return links.stream().filter(link -> link.getId().get().equals(kbLink.getApplicationId())).count() > 0L;
    }
}

