/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluencePage;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.ConfluenceKBInternalSearchService;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class KbPageViewProvider
implements CustomerResponseProvider<ConfluencePage> {
    private final UserFactory userFactory;
    private final ConfluenceKBInternalSearchService confluenceKBInternalSearchService;
    private final ErrorResultHelper errorResultHelper;
    private final ConfluenceKBErrors confluenceKbErrors;

    @Autowired
    public KbPageViewProvider(UserFactory userFactory, ConfluenceKBInternalSearchService confluenceKBInternalSearchService, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors) {
        this.userFactory = userFactory;
        this.confluenceKBInternalSearchService = confluenceKBInternalSearchService;
        this.errorResultHelper = errorResultHelper;
        this.confluenceKbErrors = confluenceKbErrors;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ConfluencePage> getResponse(ModelsRequest ctx) {
        if (ctx.getOptions().getKbPage().getId() <= 0L) {
            return io.atlassian.fugue.Either.left((Object)this.confluenceKbErrors.CONFLUENCE_PAGE_NOT_FOUND_ERROR());
        }
        long pageId = ctx.getOptions().getKbPage().getId();
        Option applicationIdOption = Option.option((Object)ctx.getOptions().getKbPage().getApplicationId());
        io.atlassian.fugue.Either checkedUserEither = StepsConverters.newerEither((Either)this.userFactory.getCheckedUser());
        if (checkedUserEither.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)checkedUserEither.left().get());
        }
        CheckedUser checkedUser = (CheckedUser)checkedUserEither.right().get();
        if (applicationIdOption.isDefined()) {
            String applicationId = (String)applicationIdOption.get();
            return this.confluenceKBInternalSearchService.find(checkedUser, pageId, applicationId);
        }
        return this.confluenceKBInternalSearchService.find(checkedUser, pageId);
    }
}

