/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.response.ForgotPasswordResponse;
import com.atlassian.servicedesk.internal.feature.customer.user.ResetPasswordService;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ForgotPasswordResponseProvider
implements CustomerResponseProvider<ForgotPasswordResponse> {
    private static String RESET_PATH = "user/forgotpassword";
    private final ResetPasswordService resetPasswordService;
    private final CustomerUrlUtil customerUrlUtil;
    private final PortalInternalManager portalInternalManager;

    @Autowired
    public ForgotPasswordResponseProvider(ResetPasswordService resetPasswordService, CustomerUrlUtil customerUrlUtil, PortalInternalManager portalInternalManager) {
        this.resetPasswordService = resetPasswordService;
        this.customerUrlUtil = customerUrlUtil;
        this.portalInternalManager = portalInternalManager;
    }

    @Override
    public Either<AnError, ForgotPasswordResponse> getResponse(ModelsRequest context) {
        boolean passwordResetSupported = this.resetPasswordService.isPasswordResetSupported();
        String resetPasswordUrl = this.getResetPasswordUrl(context.getOptions().getPortalId());
        return Either.right((Object)new ForgotPasswordResponse(passwordResetSupported, resetPasswordUrl));
    }

    private String getResetPasswordUrl(long portalId) {
        return (String)this.portalInternalManager.getPortalById(portalId).fold(error -> this.customerUrlUtil.getUrl(RESET_PATH), portal -> this.customerUrlUtil.getPortalUrl((Portal)portal, RESET_PATH));
    }
}

