/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.avatar.GravatarSettings;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.internal.api.util.ServiceDeskApplicationVersionUtil;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CalendarDateFormatResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.EnvResponseProvider;
import com.atlassian.servicedesk.internal.rest.ExternalSSORedirectService;
import com.atlassian.servicedesk.internal.rest.responses.EnvResponse;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import com.atlassian.servicedesk.plugins.coreui.internal.utils.HelpUrlHelper;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EnvResponseProviderImpl
implements EnvResponseProvider {
    private final XsrfTokenGenerator xsrfTokenGenerator;
    private final ApplicationProperties applicationProperties;
    private final JiraContactHelper jiraContactHelper;
    private final HelpUrlHelper helpUrlHelper;
    private final GravatarSettings gravatarSettings;
    private final CustomerUrlUtil customerUrlUtil;
    private final FeatureManager featureManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ExternalSSORedirectService externalSSORedirectService;
    private final CalendarDateFormatResponseProvider calendarDateFormatResponseProvider;
    private final ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil;
    private final UserFactory userFactory;
    private final WebResourceUrlProvider webResourceUrlProvider;
    private static String DEFAULT_MAX_ATTACHMENT_SIZE = "10485760";
    private static String FOOTER_FEATURE = "footer";
    private static String USER_MENU_FEATURE = "usermenu";
    private static String ALL_PORTALS_FEATURE = "allportals";

    @Autowired
    public EnvResponseProviderImpl(XsrfTokenGenerator xsrfTokenGenerator, ApplicationProperties applicationProperties, JiraContactHelper jiraContactHelper, HelpUrlHelper helpUrlHelper, GravatarSettings gravatarSettings, CustomerUrlUtil customerUrlUtil, FeatureManager featureManager, JiraAuthenticationContext authenticationContext, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, ExternalSSORedirectService externalSSORedirectService, CalendarDateFormatResponseProvider calendarDateFormatResponseProvider, ServiceDeskApplicationVersionUtil serviceDeskApplicationVersionUtil, UserFactory userFactory, WebResourceUrlProvider webResourceUrlProvider) {
        this.xsrfTokenGenerator = xsrfTokenGenerator;
        this.applicationProperties = applicationProperties;
        this.jiraContactHelper = jiraContactHelper;
        this.helpUrlHelper = helpUrlHelper;
        this.gravatarSettings = gravatarSettings;
        this.customerUrlUtil = customerUrlUtil;
        this.featureManager = featureManager;
        this.authenticationContext = authenticationContext;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.externalSSORedirectService = externalSSORedirectService;
        this.calendarDateFormatResponseProvider = calendarDateFormatResponseProvider;
        this.serviceDeskApplicationVersionUtil = serviceDeskApplicationVersionUtil;
        this.userFactory = userFactory;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    @Override
    public EnvResponse getResponse(boolean headless, boolean tourEnabled) {
        String wacLink = this.helpUrlHelper.getStaticLinks().getUrl("wac").getUrl();
        String contextPath = this.webResourceUrlProvider.getBaseUrl(UrlMode.RELATIVE);
        String contactLink = (String)this.getContactLink(contextPath).getOrNull();
        String xsrfToken = this.xsrfTokenGenerator.generateToken();
        Boolean gravatarEnabled = this.gravatarSettings.isAllowGravatars();
        String externalSsoLogoutUrl = null;
        if (this.externalSSORedirectService.isSSOAvailableForLogout()) {
            externalSsoLogoutUrl = this.externalSSORedirectService.getLogoutUrl();
        }
        List<String> disabledFeatures = Collections.emptyList();
        if (headless) {
            disabledFeatures = Arrays.asList(FOOTER_FEATURE, USER_MENU_FEATURE, ALL_PORTALS_FEATURE);
        }
        return new EnvResponse(headless, tourEnabled, wacLink, contactLink, this.serviceDeskApplicationVersionUtil.getServiceDeskApplicationVersion(), contextPath, xsrfToken, this.customerUrlUtil.getBaseUrl(false), this.customerUrlUtil.getBaseUrl(true), this.customerUrlUtil.isCustomerLoginEnabled(), this.getMaximumFileSize(), gravatarEnabled, false, disabledFeatures, this.featureManager.getDarkFeatures().getAllEnabledFeatures(), externalSsoLogoutUrl, this.calendarDateFormatResponseProvider.getCalendarDateFormatResponse(this.authenticationContext.getLocale()));
    }

    @VisibleForTesting
    Option<String> getContactLink(String baseUrl) {
        if (this.jiraContactHelper.isAdministratorContactFormEnabled() && this.currentUserCanAccessContactLink()) {
            return Option.some((Object)this.jiraContactHelper.getAdministratorContactLink(baseUrl));
        }
        return Option.none();
    }

    private boolean currentUserCanAccessContactLink() {
        return (Boolean)this.userFactory.getCheckedUser().map(arg_0 -> ((ServiceDeskLicenseAndPermissionService)this.serviceDeskLicenseAndPermissionService).canAccessJIRA(arg_0)).getOrElse((Object)true);
    }

    private String getMaximumFileSize() {
        return (String)Option.option((Object)this.applicationProperties.getDefaultBackedString("webwork.multipart.maxSize")).fold(() -> DEFAULT_MAX_ATTACHMENT_SIZE, size -> {
            try {
                Long.parseLong(size);
                return size;
            }
            catch (NumberFormatException ex) {
                return DEFAULT_MAX_ATTACHMENT_SIZE;
            }
        });
    }
}

