/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.AnnouncementResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ApprovalListResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.AvailableLanguagesResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.BrandingResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProviderDelegator;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.FeedbackConfirmResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ForgotPasswordResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.HelpCenterBrandingResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.KbPageViewProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.LoginResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PasswordPolicyResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PopularPortalResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalWebFragmentsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.PortalsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ProfileWebFragmentsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.RecentRequestTypeResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.ResponseProviderModelName;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.SharedPortalResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.SignupResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.TimezoneRegionsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.TimezonesResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.UnsubscribedConfirmationResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.VisitPortalResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.organization.CustomerOrganisationResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestCreateResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestDetailsResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.request.RequestListResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.user.UserResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerResponseProviderDelegatorImpl
implements CustomerResponseProviderDelegator {
    private final BrandingResponseProvider brandingResponseProvider;
    private final ForgotPasswordResponseProvider forgotPasswordResponseProvider;
    private final HelpCenterBrandingResponseProvider helpCenterBrandingResponseProvider;
    private final LoginResponseProvider loginResponseProvider;
    private final PasswordPolicyResponseProvider passwordPolicyResponseProvider;
    private final PortalResponseProvider portalResponseProvider;
    private final PortalsResponseProvider portalsResponseProvider;
    private final RequestCreateResponseProvider reqCreateResponseProvider;
    private final RequestDetailsResponseProvider requestDetailsResponseProvider;
    private final SharedPortalResponseProvider sharedPortalResponseProvider;
    private final SignupResponseProvider signupResponseProvider;
    private final TimezoneRegionsResponseProvider timezoneRegionsResponseProvider;
    private final TimezonesResponseProvider timezonesResponseProvider;
    private final ProfileWebFragmentsResponseProvider profileWebFragmentsResponseProvider;
    private final PortalWebFragmentsResponseProvider portalWebFragmentsResponseProvider;
    private final UserResponseProvider userResponseProvider;
    private final VisitPortalResponseProvider visitPortalResponseProvider;
    private final RequestListResponseProvider requestListResponseProvider;
    private final FeedbackConfirmResponseProvider feedbackConfirmResponseProvider;
    private final KbPageViewProvider kbPageViewProvider;
    private final PopularPortalResponseProvider popularPortalResponseProvider;
    private final RecentRequestTypeResponseProvider recentRequestTypeResponseProvider;
    private final ApprovalListResponseProvider approvalListResponseProvider;
    private final UnsubscribedConfirmationResponseProvider unsubscribedRequestNotificationResponseProvider;
    private final AnnouncementResponseProvider AnnouncementResponseProvider;
    private final CustomerOrganisationResponseProvider customerOrganisationResponseProvider;
    private final AvailableLanguagesResponseProvider availableLanguagesResponseProvider;
    private final CommonErrors commonErrors;
    @TenantAware(value=TenancyScope.TENANTLESS)
    private final Map<String, CustomerResponseProvider> providerRegistries = new HashMap<String, CustomerResponseProvider>();

    @Autowired
    public CustomerResponseProviderDelegatorImpl(BrandingResponseProvider brandingResponseProvider, ForgotPasswordResponseProvider forgotPasswordResponseProvider, HelpCenterBrandingResponseProvider helpCenterBrandingResponseProvider, LoginResponseProvider loginResponseProvider, PasswordPolicyResponseProvider passwordPolicyResponseProvider, PortalResponseProvider portalResponseProvider, PortalsResponseProvider portalsResponseProvider, RequestCreateResponseProvider requestCreateResponseProvider, RequestDetailsResponseProvider requestDetailsResponseProvider, SharedPortalResponseProvider sharedPortalResponseProvider, SignupResponseProvider signupResponseProvider, TimezoneRegionsResponseProvider timezoneRegionsResponseProvider, TimezonesResponseProvider timezonesResponseProvider, ProfileWebFragmentsResponseProvider profileWebFragmentsResponseProvider, PortalWebFragmentsResponseProvider portalWebFragmentsResponseProvider, UserResponseProvider userResponseProvider, VisitPortalResponseProvider visitPortalResponseProvider, RequestListResponseProvider requestListResponseProvider, FeedbackConfirmResponseProvider feedbackConfirmResponseProvider, KbPageViewProvider kbPageViewProvider, PopularPortalResponseProvider popularPortalResponseProvider, RecentRequestTypeResponseProvider recentRequestTypeResponseProvider, ApprovalListResponseProvider approvalListResponseProvider, UnsubscribedConfirmationResponseProvider unsubscribedRequestNotificationResponseProvider, AnnouncementResponseProvider AnnouncementResponseProvider2, CustomerOrganisationResponseProvider customerOrganisationResponseProvider, AvailableLanguagesResponseProvider availableLanguagesResponseProvider, CommonErrors commonErrors) {
        this.brandingResponseProvider = brandingResponseProvider;
        this.forgotPasswordResponseProvider = forgotPasswordResponseProvider;
        this.helpCenterBrandingResponseProvider = helpCenterBrandingResponseProvider;
        this.loginResponseProvider = loginResponseProvider;
        this.passwordPolicyResponseProvider = passwordPolicyResponseProvider;
        this.portalResponseProvider = portalResponseProvider;
        this.portalsResponseProvider = portalsResponseProvider;
        this.reqCreateResponseProvider = requestCreateResponseProvider;
        this.requestDetailsResponseProvider = requestDetailsResponseProvider;
        this.sharedPortalResponseProvider = sharedPortalResponseProvider;
        this.signupResponseProvider = signupResponseProvider;
        this.timezoneRegionsResponseProvider = timezoneRegionsResponseProvider;
        this.timezonesResponseProvider = timezonesResponseProvider;
        this.profileWebFragmentsResponseProvider = profileWebFragmentsResponseProvider;
        this.portalWebFragmentsResponseProvider = portalWebFragmentsResponseProvider;
        this.userResponseProvider = userResponseProvider;
        this.visitPortalResponseProvider = visitPortalResponseProvider;
        this.requestListResponseProvider = requestListResponseProvider;
        this.feedbackConfirmResponseProvider = feedbackConfirmResponseProvider;
        this.kbPageViewProvider = kbPageViewProvider;
        this.popularPortalResponseProvider = popularPortalResponseProvider;
        this.recentRequestTypeResponseProvider = recentRequestTypeResponseProvider;
        this.approvalListResponseProvider = approvalListResponseProvider;
        this.unsubscribedRequestNotificationResponseProvider = unsubscribedRequestNotificationResponseProvider;
        this.AnnouncementResponseProvider = AnnouncementResponseProvider2;
        this.customerOrganisationResponseProvider = customerOrganisationResponseProvider;
        this.availableLanguagesResponseProvider = availableLanguagesResponseProvider;
        this.commonErrors = commonErrors;
        this.initRegistries();
    }

    @Override
    public Either<AnError, Object> getResponse(String modelName, ModelsRequest ctx) {
        Option<CustomerResponseProvider> responseProviderOption = this.getProviderBasedOnModelName(modelName);
        if (responseProviderOption.isEmpty()) {
            return Either.left((Object)this.commonErrors.CUSTOMER_PORTAL_FORBIDDEN_MODEL());
        }
        CustomerResponseProvider responseProvider = (CustomerResponseProvider)responseProviderOption.get();
        return responseProvider.getResponse(ctx);
    }

    private void initRegistries() {
        this.providerRegistries.put(ResponseProviderModelName.ALL_REQ_FILTER_MODEL_NAME, this.requestListResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.FEEDBACK_CONFIRM_MODEL_NAME, this.feedbackConfirmResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.KB_PAGE_MODEL_NAME, this.kbPageViewProvider);
        this.providerRegistries.put(ResponseProviderModelName.POPULAR_PORTAL_MODEL_NAME, this.popularPortalResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.RECENT_REQUEST_TYPE_MODEL_NAME, this.recentRequestTypeResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.BRANDING_MODEL_NAME, this.brandingResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.FORGOT_PASSWORD_MODEL_NAME, this.forgotPasswordResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.HELP_CENTER_BRANDING_MODEL_NAME, this.helpCenterBrandingResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.LOGIN_MODEL_NAME, this.loginResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.PASSWORD_POLICY_MODEL_NAME, this.passwordPolicyResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.PORTAL_MODEL_NAME, this.portalResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.PORTALS_MODEL_NAME, this.portalsResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.REQ_CREATE_MODEL_NAME, this.reqCreateResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.REQ_DETAILS_MODEL_NAME, this.requestDetailsResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.SHARED_PORTAL_MODEL_NAME, this.sharedPortalResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.SIGN_UP_MODEL_NAME, this.signupResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.TIME_ZONE_REGIONS_MODEL_NAME, this.timezoneRegionsResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.TIME_ZONES_MODEL_NAME, this.timezonesResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.PROFILE_WEB_FRAGMENTS_MODEL_NAME, this.profileWebFragmentsResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.PORTAL_WEB_FRAGMENTS_MODEL_NAME, this.portalWebFragmentsResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.USER_MODEL_NAME, this.userResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.VISIT_PORTAL_MODEL_NAME, this.visitPortalResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.APPROVAL_LIST_FILTER_MODEL_NAME, this.approvalListResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.UNSUBSCRIBED_CONFIRMATION_MODEL_NAME, this.unsubscribedRequestNotificationResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.ANNOUNCEMENT_MODEL_NAME, this.AnnouncementResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.ORGANISATIONS_MODEL_NAME, this.customerOrganisationResponseProvider);
        this.providerRegistries.put(ResponseProviderModelName.AVAILABLE_LANGUAGES_NAME, this.availableLanguagesResponseProvider);
    }

    private Option<CustomerResponseProvider> getProviderBasedOnModelName(String modelName) {
        return Option.option((Object)this.providerRegistries.get(modelName));
    }
}

