/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CalendarDateFormatResponseProvider;
import com.atlassian.servicedesk.internal.rest.responses.CalendarDateFormatResponse;
import com.google.common.collect.Lists;
import java.text.DateFormatSymbols;
import java.util.List;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ParametersAreNonnullByDefault
@Component
public class CalendarDateFormatResponseProviderImpl
implements CalendarDateFormatResponseProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public CalendarDateFormatResponseProviderImpl(JiraAuthenticationContext jiraAuthenticationContext) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    public CalendarDateFormatResponse getCalendarDateFormatResponse() {
        return this.getCalendarDateFormatResponse(this.jiraAuthenticationContext.getLocale());
    }

    @Override
    public CalendarDateFormatResponse getCalendarDateFormatResponse(Locale locale) {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance(locale);
        List<String> months = Lists.newArrayList((Object[])dateFormatSymbols.getMonths()).subList(0, 12);
        List<String> monthsShort = Lists.newArrayList((Object[])dateFormatSymbols.getShortMonths()).subList(0, 12);
        List<String> weekdaysShort = Lists.newArrayList((Object[])dateFormatSymbols.getShortWeekdays()).subList(1, 8);
        List<String> weekdays = Lists.newArrayList((Object[])dateFormatSymbols.getWeekdays()).subList(1, 8);
        return new CalendarDateFormatResponse(months, monthsShort, weekdays, weekdaysShort);
    }
}

