/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.ThemeManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.rest.ThemeResponse;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.BrandingResponse;
import com.atlassian.servicedesk.internal.utils.CustomerUrlUtil;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BrandingResponseProvider
implements CustomerResponseProvider<BrandingResponse> {
    private final CustomerUrlUtil customerUrlUtil;
    private final ThemeManager themeManager;
    private final PortalInternalManager portalInternalManager;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final InternalPortalService internalPortalService;

    @Autowired
    public BrandingResponseProvider(CustomerUrlUtil customerUrlUtil, ThemeManager themeManager, PortalInternalManager portalInternalManager, ServiceDeskInternalManager serviceDeskInternalManager, InternalServiceDeskProjectManager serviceDeskProjectManager, InternalPortalService internalPortalService) {
        this.customerUrlUtil = customerUrlUtil;
        this.themeManager = themeManager;
        this.portalInternalManager = portalInternalManager;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.internalServiceDeskProjectManager = serviceDeskProjectManager;
        this.internalPortalService = internalPortalService;
    }

    @Override
    public Either<AnError, BrandingResponse> getResponse(ModelsRequest ctx) {
        return Steps.begin(this.portalInternalManager.getPortalById(ctx.getOptions().getPortalId())).then(portal -> this.internalServiceDeskProjectManager.getProject(Long.valueOf(this.internalPortalService.getProjectIdForPortal((Portal)portal)))).then((portal, project) -> this.serviceDeskInternalManager.getServiceDesk((Project)project, false)).then((portal, project, serviceDesk) -> this.getResponse((Portal)portal)).yield((portal, project, serviceDesk, response) -> response);
    }

    private Either<AnError, BrandingResponse> getResponse(Portal portal) {
        String portalBaseUrl = this.customerUrlUtil.getPortalUrlSimple(portal);
        String logoUrl = null;
        if (this.internalPortalService.getLogoId(portal).isDefined()) {
            logoUrl = this.customerUrlUtil.getRestUrl() + "/customer/viewport-resources/image" + "/" + this.internalPortalService.getLogoId(portal).get();
        }
        ThemeResponse themeResponse = (ThemeResponse)Steps.begin(this.internalPortalService.getThemeId(portal)).then(themeId -> this.themeManager.getPortalTheme((int)themeId).toOption()).yield((themeId, theme) -> ThemeResponse.toThemeResponse(theme)).getOrNull();
        return Either.right((Object)new BrandingResponse(String.valueOf(portal.getId()), this.internalPortalService.getPortalKey(portal), portal.getName(), portalBaseUrl, logoUrl, themeResponse));
    }
}

