/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.feature.customer.user.UserLanguageHelper;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.CustomerLanguageResponse;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AvailableLanguagesResponseProvider
implements CustomerResponseProvider<List<CustomerLanguageResponse>> {
    private final UserLanguageHelper userLanguageHelper;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public AvailableLanguagesResponseProvider(UserLanguageHelper userLanguageHelper, ApplicationProperties applicationProperties) {
        this.userLanguageHelper = userLanguageHelper;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public Either<AnError, List<CustomerLanguageResponse>> getResponse(ModelsRequest ctx) {
        return Either.right(this.retrieveInstalledLanguages());
    }

    @VisibleForTesting
    List<CustomerLanguageResponse> retrieveInstalledLanguages() {
        Locale defaultLocale = this.applicationProperties.getDefaultLocale();
        return this.userLanguageHelper.getInstalledLocales().stream().map(locale -> this.toAvailableLanguageResponse((Locale)locale, defaultLocale)).sorted((lhs, rhs) -> {
            if (lhs.isDefaultLanguage()) {
                return -1;
            }
            if (rhs.isDefaultLanguage()) {
                return 1;
            }
            return lhs.getDisplayName().compareTo(rhs.getDisplayName());
        }).collect(Collectors.toList());
    }

    private CustomerLanguageResponse toAvailableLanguageResponse(Locale locale, Locale defaultLocale) {
        return new CustomerLanguageResponse(locale.toString(), this.userLanguageHelper.getLocaleDisplayName(locale, defaultLocale), Objects.equals(locale, defaultLocale));
    }
}

