/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.providers;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.feature.announcement.Announcement;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.AnnouncementWithWiki;
import com.atlassian.servicedesk.internal.feature.customer.portal.providers.CustomerResponseProvider;
import com.atlassian.servicedesk.internal.rest.requests.ModelsRequest;
import com.atlassian.servicedesk.internal.rest.responses.AnnouncementResponse;
import com.atlassian.servicedesk.internal.soy.RenderOption;
import com.atlassian.servicedesk.internal.soy.RichTextRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementResponseProvider
implements CustomerResponseProvider<AnnouncementResponse> {
    private final AnnouncementService announcementService;
    private final RichTextRenderer richTextRenderer;
    private final UserFactory userFactory;

    @Autowired
    public AnnouncementResponseProvider(AnnouncementService announcementService, RichTextRenderer richTextRenderer, UserFactory userFactory) {
        this.announcementService = announcementService;
        this.richTextRenderer = richTextRenderer;
        this.userFactory = userFactory;
    }

    @Override
    public Either<AnError, AnnouncementResponse> getResponse(ModelsRequest ctx) {
        UncheckedUser user = this.userFactory.getUncheckedUser();
        Either<AnError, Announcement> announcementEither = this.announcementService.getHelpCenterHeaderAnnouncement(user);
        return announcementEither.map(announcement -> this.getAnnouncementResponse(user, (Announcement)announcement));
    }

    private AnnouncementResponse getAnnouncementResponse(UncheckedUser user, Announcement announcement) {
        Option checkedUser = StepsConverters.newerOption((com.atlassian.fugue.Option)user.asCheckedUser());
        String header = announcement.getHeaderAsText();
        String headerWiki = this.richTextRenderer.renderCustomerWiki(header, (Option<CheckedUser>)checkedUser, RenderOption.OPEN_LINKS_IN_NEW_TAB);
        AnnouncementWithWiki announcementHeaderWithWiki = new AnnouncementWithWiki(header, headerWiki);
        String message = announcement.getMessageAsText();
        String messageWiki = this.richTextRenderer.renderCustomerWiki(message, (Option<CheckedUser>)checkedUser, RenderOption.OPEN_LINKS_IN_NEW_TAB);
        AnnouncementWithWiki announcementMessageWithWiki = new AnnouncementWithWiki(message, messageWiki);
        boolean canEditAnnouncement = (Boolean)checkedUser.map(this.announcementService::canEditHelpCenterAnnouncement).getOrElse((Object)false);
        return new AnnouncementResponse(header, announcementHeaderWithWiki.getWikiText(), message, announcementMessageWithWiki.getWikiText(), canEditAnnouncement, (Option<Portal>)Option.none());
    }
}

