/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.internal.feature.customer.portal.lookandfeel.Theme;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.ConstructorExpression;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ThemeStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public ThemeStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    private static ConstructorExpression<Theme> MAPPER() {
        return Projections.constructor(Theme.class, (Expression[])new Expression[]{Tables.THEME.ID, Tables.THEME.HEADER_BGCOLOR, Tables.THEME.HEADER_LINK_COLOR, Tables.THEME.HEADER_LINK_HOVER_COLOR, Tables.THEME.HEADER_LINK_HOVER_BGCOLOR});
    }

    public Theme getPortalTheme(int portalId) {
        Theme theme = (Theme)this.databaseAccessor.runInTransaction(databaseConnection -> (Theme)((SQLQuery)((SQLQuery)databaseConnection.select(ThemeStore.MAPPER()).from((Expression)Tables.THEME)).where((Predicate)Tables.THEME.ID.eq((Object)portalId))).fetchFirst());
        return theme;
    }

    public void deleteTheme(int themeId) {
        this.databaseAccessor.runInTransaction(databaseConnection -> databaseConnection.delete((RelationalPath)Tables.THEME).where((Predicate)Tables.THEME.ID.eq((Object)themeId)).execute());
    }

    public Integer createTheme(Theme theme) {
        Integer id = (Integer)this.databaseAccessor.runInTransaction(databaseConnection -> (Integer)databaseConnection.insert((RelationalPath)Tables.THEME).set((Path)Tables.THEME.HEADER_BGCOLOR, (Object)theme.getHeaderBGColor()).set((Path)Tables.THEME.HEADER_LINK_COLOR, (Object)theme.getHeaderLinkColor()).set((Path)Tables.THEME.HEADER_LINK_HOVER_COLOR, (Object)theme.getHeaderLinkHoverColor()).set((Path)Tables.THEME.HEADER_LINK_HOVER_BGCOLOR, (Object)theme.getHeaderLinkHoverBGColor()).executeWithKey(Tables.THEME.ID));
        return id;
    }
}

