/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.fugue.Option;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.util.fp.FpKit;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class PortalQStore {
    private static final Logger log = LoggerFactory.getLogger(PortalQStore.class);
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public PortalQStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public io.atlassian.fugue.Option<Portal> getPortalById(int portalId) {
        Tuple tuple = (Tuple)this.databaseAccessor.runInTransaction(conn -> (Tuple)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.PORTAL.all()).from((Expression)Tables.PORTAL)).where((Predicate)Tables.PORTAL.ID.eq((Object)portalId))).fetchFirst());
        return io.atlassian.fugue.Option.option((Object)tuple).flatMap(this::toPortal);
    }

    public io.atlassian.fugue.Option<PortalInternal> getPortalByKey(String portalKey) {
        Tuple tuple = (Tuple)this.databaseAccessor.runInTransaction(conn -> (Tuple)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.PORTAL.all()).from((Expression)Tables.PORTAL)).where((Predicate)Tables.PORTAL.KEY.eq((Object)portalKey))).fetchFirst());
        return io.atlassian.fugue.Option.option((Object)tuple).flatMap(this::toPortal);
    }

    public io.atlassian.fugue.Option<PortalInternal> getPortalByProjectId(Long projectId) {
        Tuple tuple = (Tuple)this.databaseAccessor.runInTransaction(conn -> (Tuple)((SQLQuery)((SQLQuery)conn.select((Expression[])Tables.PORTAL.all()).from((Expression)Tables.PORTAL)).where((Predicate)Tables.PORTAL.PROJECT_ID.eq((Object)projectId))).fetchFirst());
        return io.atlassian.fugue.Option.option((Object)tuple).flatMap(this::toPortal);
    }

    public List<PortalInternal> getAllPortals() {
        List portals = (List)this.databaseAccessor.runInTransaction(conn -> ((SQLQuery)conn.select((Expression[])Tables.PORTAL.all()).from((Expression)Tables.PORTAL)).fetch());
        return FpKit.flatMap((List)portals, tuple -> FpKit.toList((Option)StepsConverters.olderOption(this.toPortal((Tuple)tuple))));
    }

    public io.atlassian.fugue.Option<Portal> addPortal(Portal portal) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.addPortal(portal, (DatabaseConnection)conn));
    }

    public io.atlassian.fugue.Option<Portal> addPortal(Portal portal, DatabaseConnection connection) {
        PortalInternal portalInternal = (PortalInternal)portal;
        Integer newId = (Integer)connection.insert((RelationalPath)Tables.PORTAL).set((Path)Tables.PORTAL.DESCRIPTION, (Object)portalInternal.getDescription()).set((Path)Tables.PORTAL.NAME, (Object)portalInternal.getName()).set((Path)Tables.PORTAL.KEY, (Object)portalInternal.getKey()).set(Tables.PORTAL.PROJECT_ID, (Object)portalInternal.getProjectId()).set((Path)Tables.PORTAL.SEND_EMAIL_NOTIFICATIONS, (Object)portalInternal.getSendEmailNotification()).executeWithKey(Tables.PORTAL.ID);
        return io.atlassian.fugue.Option.option((Object)newId).flatMap(nonNullId -> this.getPortalById((int)nonNullId, connection));
    }

    public JSDSuccess deletePortal(int portalId) {
        return (JSDSuccess)((Object)this.databaseAccessor.runInTransaction(conn -> this.deletePortal(portalId, (DatabaseConnection)conn)));
    }

    public JSDSuccess deletePortal(int portalId, DatabaseConnection databaseConnection) {
        databaseConnection.delete((RelationalPath)Tables.PORTAL).where((Predicate)Tables.PORTAL.ID.eq((Object)portalId)).execute();
        return JSDSuccess.success();
    }

    public io.atlassian.fugue.Option<Portal> updateName(int portalId, String name) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.setPortalRowValue(portalId, (Path)Tables.PORTAL.NAME, (Object)name, (DatabaseConnection)conn));
    }

    public io.atlassian.fugue.Option<Portal> updateDescription(int portalId, String description) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.setPortalRowValue(portalId, (Path)Tables.PORTAL.DESCRIPTION, (Object)description, (DatabaseConnection)conn));
    }

    public io.atlassian.fugue.Option<Portal> clearLogo(int portalId) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.clearPortalRowValue(portalId, (Path)Tables.PORTAL.LOGO_ID, (DatabaseConnection)conn));
    }

    public io.atlassian.fugue.Option<Portal> setLogo(int portalId, int logoId) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.setPortalRowValue(portalId, (Path)Tables.PORTAL.LOGO_ID, logoId, (DatabaseConnection)conn));
    }

    public io.atlassian.fugue.Option<Portal> clearTheme(int portalId) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.clearPortalRowValue(portalId, (Path)Tables.PORTAL.THEME_ID, (DatabaseConnection)conn));
    }

    public io.atlassian.fugue.Option<Portal> setTheme(int portalId, int themeId) {
        return (io.atlassian.fugue.Option)this.databaseAccessor.runInTransaction(conn -> this.setPortalRowValue(portalId, (Path)Tables.PORTAL.THEME_ID, themeId, (DatabaseConnection)conn));
    }

    private io.atlassian.fugue.Option<Portal> getPortalById(int portalId, DatabaseConnection databaseConnection) {
        Tuple tuple = (Tuple)((SQLQuery)((SQLQuery)databaseConnection.select((Expression[])Tables.PORTAL.all()).from((Expression)Tables.PORTAL)).where((Predicate)Tables.PORTAL.ID.eq((Object)portalId))).fetchFirst();
        return io.atlassian.fugue.Option.option((Object)tuple).flatMap(this::toPortal);
    }

    private <T> io.atlassian.fugue.Option<Portal> clearPortalRowValue(int portalId, Path<T> row, DatabaseConnection databaseConnection) {
        return this.setPortalRowValue(portalId, row, null, databaseConnection);
    }

    private <T> io.atlassian.fugue.Option<Portal> setPortalRowValue(int portalId, Path<T> row, @Nullable T value, DatabaseConnection databaseConnection) {
        databaseConnection.update((RelationalPath)Tables.PORTAL).where((Predicate)Tables.PORTAL.ID.eq((Object)portalId)).set(row, value).execute();
        return this.getPortalById(portalId, databaseConnection);
    }

    private io.atlassian.fugue.Option<PortalInternal> toPortal(Tuple tuple) {
        return Steps.begin(this.getAndCheckNonNull(tuple, (Expression)Tables.PORTAL.ID, "id")).then(id -> this.getAndCheckNonNull(tuple, (Expression)Tables.PORTAL.KEY, "key")).then((id, key) -> this.getAndCheckNonNull(tuple, (Expression)Tables.PORTAL.NAME, "name")).then((id, key, name) -> this.getAndCheckNonNull(tuple, (Expression)Tables.PORTAL.PROJECT_ID, "projectId")).yield((id, key, name, projectId) -> {
            String desc = StringUtils.defaultString((String)((String)tuple.get((Expression)Tables.PORTAL.DESCRIPTION)));
            io.atlassian.fugue.Option logoId = io.atlassian.fugue.Option.option((Object)tuple.get(Tables.PORTAL.LOGO_ID));
            io.atlassian.fugue.Option themeId = io.atlassian.fugue.Option.option((Object)tuple.get(Tables.PORTAL.THEME_ID));
            Boolean sendNotification = (Boolean)io.atlassian.fugue.Option.option((Object)tuple.get((Expression)Tables.PORTAL.SEND_EMAIL_NOTIFICATIONS)).getOrElse((Object)false);
            return new PortalInternal((int)id, (String)key, (String)name, desc, sendNotification, (Long)projectId, (io.atlassian.fugue.Option<Integer>)logoId, (io.atlassian.fugue.Option<Integer>)themeId);
        });
    }

    private <T> io.atlassian.fugue.Option<T> getAndCheckNonNull(Tuple tuple, Expression<T> expression, String columnName) {
        Object value = tuple.get(expression);
        if (value == null) {
            log.debug("Portal property {} is missing", (Object)columnName);
        }
        return io.atlassian.fugue.Option.option((Object)value);
    }
}

