/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.customer.CustomerContextService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalAvatarChangeRequest;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternal;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalLookAndFeelChangeRequest;
import com.atlassian.servicedesk.internal.feature.servicedesk.ServiceDeskInternalManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InternalPortalServiceImpl
implements InternalPortalService {
    private final InternalServiceDeskProjectManager serviceDeskProjectManager;
    private final PortalInternalManager portalInternalManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ServiceDeskInternalManager serviceDeskInternalManager;
    private final ErrorResultHelper errorResultHelper;
    private final CommonErrors sdErrors;
    private final CustomerContextService customerContextService;

    @Autowired
    public InternalPortalServiceImpl(InternalServiceDeskProjectManager serviceDeskProjectManager, PortalInternalManager portalInternalManager, ServiceDeskPermissions serviceDeskPermissions, ServiceDeskInternalManager serviceDeskInternalManager, ErrorResultHelper errorResultHelper, CommonErrors sdErrors, CustomerContextService customerContextService) {
        this.serviceDeskProjectManager = serviceDeskProjectManager;
        this.portalInternalManager = portalInternalManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.serviceDeskInternalManager = serviceDeskInternalManager;
        this.errorResultHelper = errorResultHelper;
        this.sdErrors = sdErrors;
        this.customerContextService = customerContextService;
    }

    @Override
    public Either<AnError, Portal> updatePortalDesc(CheckedUser user, Project project, Portal portal, String desc) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.sdErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.portalInternalManager.updatePortalDesc(portal.getId(), desc);
    }

    @Override
    public Either<AnError, Portal> updatePortalName(CheckedUser user, Project project, Portal portal, String name) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.sdErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.portalInternalManager.updatePortalName(portal.getId(), name);
    }

    @Override
    public List<Portal> getCustomerVisiblePortals(CheckedUser user) {
        List<PortalInternal> portals = this.portalInternalManager.getPortals();
        return portals.stream().filter(portal -> this.serviceDeskProjectManager.getProject(Long.valueOf(this.toPortalInternal((Portal)portal).getProjectId())).exists(project -> this.isCustomerVisiblePortal(user, (Project)project))).collect(Collectors.toList());
    }

    @Override
    public List<Portal> getPortals(CheckedUser user) {
        return this.portalInternalManager.getPortals().stream().filter(portal -> this.checkPermission(user, (Portal)portal).isRight()).collect(Collectors.toList());
    }

    @Override
    public List<Portal> getPortalsOverrideSecurity() {
        return Lists.transform(this.portalInternalManager.getPortals(), portalInternal -> portalInternal);
    }

    @Override
    public Either<AnError, Portal> getPortalByProject(CheckedUser user, Project project) {
        return Steps.begin(this.portalInternalManager.getPortalByProject(project)).then(portal -> this.checkPermission(user, (Portal)portal)).yield((portal, hasPermission) -> portal);
    }

    @Override
    public Either<AnError, Portal> getPortalById(CheckedUser user, Long id) {
        return Steps.begin(this.portalInternalManager.getPortalById(id)).then(portal -> this.checkPermission(user, (Portal)portal)).yield((portal, hasPermission) -> portal);
    }

    @Override
    public Either<AnError, PortalInternal> getPortal(CheckedUser user, String portalKey) {
        return Steps.begin(this.portalInternalManager.getPortalByKey(portalKey)).then(portal -> this.checkPermission(user, (Portal)portal)).yield((portal, hasPermission) -> portal);
    }

    @Override
    public Either<AnError, Portal> updatePortalLookAndFeel(CheckedUser user, Project project, Portal portal, PortalLookAndFeelChangeRequest change) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.sdErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.portalInternalManager.updatePortalLookAndFeel(portal, change);
    }

    @Override
    public Either<AnError, Portal> updatePortalAvatar(CheckedUser user, Project project, Portal portal, PortalAvatarChangeRequest portalAvatarChange) {
        if (!this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.left((Object)this.sdErrors.ADMINISTER_PERMISSIONS_ERROR());
        }
        return this.portalInternalManager.updatePortalAvatar(portal, portalAvatarChange);
    }

    @Override
    public Either<AnError, Portal> getFirstPortalByConfluenceSpaceKey(CheckedUser user, String spaceKey) {
        Either<AnError, List<PortalInternal>> portalsEither = this.portalInternalManager.getPortalsByConfluenceSpaceKey(spaceKey);
        if (portalsEither.isLeft()) {
            return Either.left((Object)portalsEither.left().get());
        }
        List portals = (List)portalsEither.right().get();
        Option firstPortalOption = Iterables.findFirst((Iterable)portals, portal -> {
            Either projectEither = this.serviceDeskProjectManager.getProject(Long.valueOf(portal.getProjectId()));
            if (projectEither.isLeft()) {
                return false;
            }
            Project project = (Project)projectEither.right().get();
            return this.serviceDeskPermissions.canViewPortal((SDUser)user, project);
        });
        if (firstPortalOption.isEmpty()) {
            AnError anError = this.errorResultHelper.notFound404("sd.portal.error.no.portal.found.for.space.key", new Object[]{spaceKey}).user(user.forJIRA()).build();
            return Either.left((Object)anError);
        }
        return Either.right((Object)firstPortalOption.get());
    }

    @Override
    public Either<AnError, PortalInternal> getPortalByProjectWithoutPermission(Project project) {
        return this.portalInternalManager.getPortalByProject(project);
    }

    @Override
    public long getProjectIdForPortal(Portal portal) {
        return this.toPortalInternal(portal).getProjectId();
    }

    @Override
    public String getPortalKey(Portal portal) {
        return this.toPortalInternal(portal).getKey();
    }

    @Override
    public Option<Integer> getLogoId(Portal portal) {
        return this.toPortalInternal(portal).getLogoId();
    }

    @Override
    public Option<Integer> getThemeId(Portal portal) {
        return this.toPortalInternal(portal).getThemeId();
    }

    @Override
    public PortalInternal toPortalInternal(Portal portal) {
        return this.portalInternalManager.toPortalInternal(portal);
    }

    private Either<AnError, Boolean> checkPermission(CheckedUser user, Portal portal) {
        return Steps.begin((Either)this.serviceDeskProjectManager.getProject(Long.valueOf(this.toPortalInternal(portal).getProjectId()))).then(project -> {
            boolean hasPermission = this.serviceDeskPermissions.canViewPortal((SDUser)user, (Project)project);
            return Eithers.cond((boolean)hasPermission, (Object)this.sdErrors.PORTAL_NOT_AUTHORISED(), (Object)hasPermission);
        }).yield((project, hasPermission) -> hasPermission);
    }

    private boolean hasCustomerPortalPermission(CheckedUser user, Project project) {
        return (Boolean)this.customerContextService.runInCustomerContext(() -> this.serviceDeskPermissions.canViewPortal((SDUser)user, project) && this.serviceDeskPermissions.canCreateRequest((SDUser)user, project));
    }

    private boolean isCustomerVisiblePortal(CheckedUser user, Project project) {
        boolean hasCustomerPortalPermission = this.hasCustomerPortalPermission(user, project);
        boolean hasServiceDesk = this.serviceDeskInternalManager.hasServiceDesk(project, false);
        return hasCustomerPortalPermission && hasServiceDesk;
    }
}

