/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.portal;

import com.atlassian.lookandfeel.ColorScheme;
import com.atlassian.lookandfeel.ColorSchemeGenerator;
import com.atlassian.lookandfeel.ImageInfo;
import com.atlassian.servicedesk.internal.images.ImageFileQStore;
import io.atlassian.fugue.Option;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
final class ImageColorSchemeGenerator {
    private static final Logger log = LoggerFactory.getLogger(ImageColorSchemeGenerator.class);
    private final ImageFileQStore imageStore;

    @Autowired
    public ImageColorSchemeGenerator(ImageFileQStore imageStore) {
        this.imageStore = imageStore;
    }

    Option<ColorScheme> generate(int imageId) {
        return this.imageStore.getImageById(imageId).flatMap(this::generateForImageStream);
    }

    private Option<ColorScheme> generateForImageStream(InputStream imageInputStream) {
        return this.readImageFromInputStream(imageInputStream).flatMap(this::generateForImage);
    }

    private Option<BufferedImage> readImageFromInputStream(InputStream imageInputStream) {
        try {
            return Option.option((Object)ImageIO.read(imageInputStream));
        }
        catch (IOException e) {
            log.warn("Unable to generate color scheme for image", (Throwable)e);
            return Option.none();
        }
    }

    private Option<ColorScheme> generateForImage(BufferedImage bufferedImage) {
        return Option.option((Object)ColorSchemeGenerator.generateFromLogo((ImageInfo)new ImageInfo(bufferedImage)));
    }
}

