/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.helpcenter;

import com.atlassian.lookandfeel.ColorScheme;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBranding;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.HelpCenterBrandingDBMapper;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.ValidatedColors;
import com.atlassian.servicedesk.internal.feature.customer.helpcenter.ValidatedHelpCenterBranding;
import com.atlassian.servicedesk.internal.querydsl.mapping.Tables;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLUpdateClause;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HelpCenterBrandingQStore {
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public HelpCenterBrandingQStore(DatabaseAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    public HelpCenterBranding updateLogo(Option<ColorScheme> colorScheme, int logoId) {
        return (HelpCenterBranding)this.databaseAccessor.runInTransaction(conn -> {
            int id = this.getOrCreateHelpCenterBrandingId((DatabaseConnection)conn);
            SQLUpdateClause updateClause = conn.update((RelationalPath)Tables.HELP_CENTER_BRANDING).set(Tables.HELP_CENTER_BRANDING.LOGO_ID, (Object)logoId);
            if (!colorScheme.isEmpty()) {
                ColorScheme cs = (ColorScheme)colorScheme.get();
                updateClause.set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BGCOLOR, (Object)cs.getHeader().getHexString()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_COLOR, (Object)cs.getHeaderText().getHexString()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_COLOR, (Object)cs.getHeaderHighlightText().getHexString()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_BGCOLOR, (Object)cs.getHeaderHighlight().getHexString()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BADGE_BGCOLOR, (Object)cs.getHeroButton().getHexString());
            }
            updateClause.where((Predicate)Tables.HELP_CENTER_BRANDING.ID.eq((Object)id)).execute();
            return this.getHelpCenterBranding((DatabaseConnection)conn, id);
        });
    }

    private HelpCenterBranding getHelpCenterBranding(DatabaseConnection conn, int id) {
        return (HelpCenterBranding)((SQLQuery)((SQLQuery)conn.select((Expression)new HelpCenterBrandingDBMapper()).from((Expression)Tables.HELP_CENTER_BRANDING)).where((Predicate)Tables.HELP_CENTER_BRANDING.ID.eq((Object)id))).fetchFirst();
    }

    public void updateColors(ValidatedColors validatedColors) {
        this.databaseAccessor.runInTransaction(conn -> {
            int id = this.getOrCreateHelpCenterBrandingId((DatabaseConnection)conn);
            return conn.update((RelationalPath)Tables.HELP_CENTER_BRANDING).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BGCOLOR, (Object)validatedColors.getHeaderBGColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_COLOR, (Object)validatedColors.getHeaderLinkColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_COLOR, (Object)validatedColors.getHeaderLinkHoverColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_BGCOLOR, (Object)validatedColors.getHeaderLinkHoverBGColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BADGE_BGCOLOR, (Object)validatedColors.getHeaderBadgeBGColor()).where((Predicate)Tables.HELP_CENTER_BRANDING.ID.eq((Object)id)).execute();
        });
    }

    public HelpCenterBranding clearTheme() {
        return (HelpCenterBranding)this.databaseAccessor.runInNewTransaction(conn -> {
            int id = this.getOrCreateHelpCenterBrandingId((DatabaseConnection)conn);
            conn.update((RelationalPath)Tables.HELP_CENTER_BRANDING).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BGCOLOR, (Object)"").set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_COLOR, (Object)"").set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_COLOR, (Object)"").set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_BGCOLOR, (Object)"").set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BADGE_BGCOLOR, (Object)"").setNull(Tables.HELP_CENTER_BRANDING.LOGO_ID).where((Predicate)Tables.HELP_CENTER_BRANDING.ID.eq((Object)id)).execute();
            return this.getHelpCenterBranding((DatabaseConnection)conn, id);
        });
    }

    public String updateHelpCenterTitle(String title) {
        this.databaseAccessor.runInTransaction(conn -> {
            int id = this.getOrCreateHelpCenterBrandingId((DatabaseConnection)conn);
            return conn.update((RelationalPath)Tables.HELP_CENTER_BRANDING).set((Path)Tables.HELP_CENTER_BRANDING.HELP_CENTER_TITLE, (Object)title).where((Predicate)Tables.HELP_CENTER_BRANDING.ID.eq((Object)id)).execute();
        });
        return title;
    }

    public HelpCenterBranding getHelpCenterBranding() {
        return (HelpCenterBranding)this.databaseAccessor.runInTransaction(conn -> {
            int id = this.getOrCreateHelpCenterBrandingId((DatabaseConnection)conn);
            return this.getHelpCenterBranding((DatabaseConnection)conn, id);
        });
    }

    public Option<HelpCenterBranding> getGlobalTheme() {
        return (Option)this.databaseAccessor.runInTransaction(conn -> {
            Integer id = this.getId((DatabaseConnection)conn);
            if (id == null) {
                return Option.none();
            }
            return Option.option((Object)this.getHelpCenterBranding((DatabaseConnection)conn, id));
        });
    }

    public HelpCenterBranding updateHelpCenterBranding(ValidatedHelpCenterBranding validatedHelpCenterBranding) {
        return (HelpCenterBranding)this.databaseAccessor.runInTransaction(conn -> {
            int id = this.getOrCreateHelpCenterBrandingId((DatabaseConnection)conn);
            SQLUpdateClause setClause = conn.update((RelationalPath)Tables.HELP_CENTER_BRANDING).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_BGCOLOR, (Object)validatedHelpCenterBranding.getHeaderBGColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_COLOR, (Object)validatedHelpCenterBranding.getHeaderLinkColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_COLOR, (Object)validatedHelpCenterBranding.getHeaderLinkHoverColor()).set((Path)Tables.HELP_CENTER_BRANDING.HEADER_LINK_HOVER_BGCOLOR, (Object)validatedHelpCenterBranding.getHeaderLinkHoverBGColor()).set((Path)Tables.HELP_CENTER_BRANDING.HELP_CENTER_TITLE, (Object)validatedHelpCenterBranding.getHelpCenterTitle());
            if (validatedHelpCenterBranding.isUsingLogo()) {
                if (validatedHelpCenterBranding.getLogoId().isDefined()) {
                    setClause.set(Tables.HELP_CENTER_BRANDING.LOGO_ID, validatedHelpCenterBranding.getLogoId().get());
                }
            } else {
                setClause.setNull(Tables.HELP_CENTER_BRANDING.LOGO_ID);
            }
            setClause.where((Predicate)Tables.HELP_CENTER_BRANDING.ID.eq((Object)id)).execute();
            return this.getHelpCenterBranding((DatabaseConnection)conn, id);
        });
    }

    private int getOrCreateHelpCenterBrandingId(DatabaseConnection conn) {
        Integer id = this.getId(conn);
        if (id == null) {
            return this.createHelpCenterBranding(conn);
        }
        return id;
    }

    private Integer createHelpCenterBranding(DatabaseConnection conn) {
        return (Integer)conn.insert((RelationalPath)Tables.HELP_CENTER_BRANDING).setNull((Path)Tables.HELP_CENTER_BRANDING.HELP_CENTER_TITLE).executeWithKey(Tables.HELP_CENTER_BRANDING.ID);
    }

    private Integer getId(DatabaseConnection conn) {
        return (Integer)((SQLQuery)conn.select(Tables.HELP_CENTER_BRANDING.ID).from((Expression)Tables.HELP_CENTER_BRANDING)).fetchFirst();
    }
}

