/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.condition;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.organization.member.CustomerOrganizationMemberService;
import com.atlassian.servicedesk.internal.feature.reqparticipants.permission.RequestParticipantPermissionService;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;

public class CanShareRequestCondition
implements Condition {
    public static final String ISSUE = "issue";
    public static final String PROJECT = "project";
    public static final String USER = "user";
    private final RequestParticipantPermissionService requestParticipantPermissionService;
    private final CustomerOrganizationMemberService customerOrganizationMemberService;
    private final FeatureManager featureManager;
    private final UserFactory userFactory;
    private final PermissionManager permissionManager;

    public CanShareRequestCondition(RequestParticipantPermissionService requestParticipantPermissionService, CustomerOrganizationMemberService customerOrganizationMemberService, FeatureManager featureManager, UserFactory userFactory, PermissionManager permissionManager) {
        this.requestParticipantPermissionService = requestParticipantPermissionService;
        this.customerOrganizationMemberService = customerOrganizationMemberService;
        this.featureManager = featureManager;
        this.userFactory = userFactory;
        this.permissionManager = permissionManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(@Nonnull Map<String, Object> context) {
        Issue issue = (Issue)context.get(ISSUE);
        if (issue == null) {
            return false;
        }
        ApplicationUser user = (ApplicationUser)context.get(USER);
        if (user == null) {
            return false;
        }
        return (Boolean)this.userFactory.wrap(user).map(checkedUser -> this.shouldShowShareRequest((CheckedUser)checkedUser, issue)).getOrElse((Object)false);
    }

    public boolean shouldShowShareRequest(CheckedUser user, Issue issue) {
        boolean canAddAnyParticipant = this.requestParticipantPermissionService.canAddAnyParticipant(user, issue);
        if (canAddAnyParticipant) {
            return true;
        }
        if (this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            Collection userOrganisations = (Collection)this.customerOrganizationMemberService.getUserOrganizationsInProjectAsCustomer(user, issue.getProjectObject()).getOrElse(Collections.emptyList());
            boolean isUserBelongToAnyOrganisation = !userOrganisations.isEmpty();
            return isUserBelongToAnyOrganisation && this.permissionManager.hasPermission(ProjectPermissions.EDIT_ISSUES, issue, user.forJIRA());
        }
        return false;
    }
}

