/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.approvals;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.query.Query;
import com.atlassian.query.operator.Operator;
import com.atlassian.query.order.SortOrder;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalCustomFieldHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalPluginInfo;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalQueueCreationHelper;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectQueueMetadata;
import io.atlassian.fugue.Option;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalQueueCreationHelperImpl
implements ApprovalQueueCreationHelper {
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final ApprovalCustomFieldHelper approvalCustomFieldHelper;

    @Autowired
    public ApprovalQueueCreationHelperImpl(I18nHelper.BeanFactory i18nBeanFactory, SearchService searchService, ApplicationProperties applicationProperties, ApprovalCustomFieldHelper approvalCustomFieldHelper) {
        this.i18nBeanFactory = i18nBeanFactory;
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.approvalCustomFieldHelper = approvalCustomFieldHelper;
    }

    @Override
    public boolean canCreateQueue() {
        return this.approvalCustomFieldHelper.getApprovalCustomField().isDefined();
    }

    @Override
    public Option<PremadeProjectQueueMetadata> approvedQueue(int order) {
        String queueName = this.getI18N().getText("sd.premade.queue.approved.name");
        return this.createApproveQueueMetaData(order, queueName, customField -> this.approveQuery((CustomField)customField));
    }

    @Override
    public Option<PremadeProjectQueueMetadata> changeApprovedQueue(int order) {
        String queueName = this.getI18N().getText("sd.project.template.itil.queues.approved.name");
        return this.createApproveQueueMetaData(order, queueName, customField -> this.changeApprovedQuery((CustomField)customField));
    }

    private Option<PremadeProjectQueueMetadata> createApproveQueueMetaData(int order, String queueName, Function<CustomField, Query> queryProvider) {
        Option<CustomField> approvalCustomFieldOpt = this.approvalCustomFieldHelper.getApprovalCustomField();
        if (approvalCustomFieldOpt.isEmpty()) {
            return Option.none();
        }
        CustomField approvalCustomField = (CustomField)approvalCustomFieldOpt.get();
        Query jqlQuery = queryProvider.apply(approvalCustomField);
        String queryString = this.searchService.getJqlString(jqlQuery);
        PremadeProjectQueueMetadata queueMetadata = new PremadeProjectQueueMetadata(queueName, queryString, order);
        return Option.some((Object)queueMetadata);
    }

    private Query approveQuery(CustomField approvalCustomField) {
        return JqlQueryBuilder.newBuilder().where().unresolved().and().addFunctionCondition(approvalCustomField.getName(), Operator.EQUALS, ApprovalPluginInfo.APPROVED_APPROVAL_SEARCH_FUNCTION_NAME).endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
    }

    private Query changeApprovedQuery(CustomField approvalCustomField) {
        I18nHelper i18nHelper = this.getI18N();
        return JqlQueryBuilder.newBuilder().where().unresolved().and().issueType().eq(i18nHelper.getText("sd.project.template.itil.issuetype.change.name")).and().addFunctionCondition(approvalCustomField.getName(), Operator.EQUALS, ApprovalPluginInfo.APPROVED_APPROVAL_SEARCH_FUNCTION_NAME).endWhere().orderBy().createdDate(SortOrder.DESC).buildQuery();
    }

    private I18nHelper getI18N() {
        return this.i18nBeanFactory.getInstance(this.applicationProperties.getDefaultLocale());
    }
}

