/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.customer.approvals;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.config.StatusCategoryManager;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalGettingStartedHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalQueueCreationHelper;
import com.atlassian.servicedesk.internal.feature.customer.approvals.ApprovalWorkflowImporterHelper;
import com.atlassian.servicedesk.internal.feature.gettingstarted.ServiceDeskProjectTemplateType;
import com.atlassian.servicedesk.internal.feature.gettingstarted.metadata.PremadeProjectQueueMetadata;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApprovalGettingStartedHelperImpl
implements ApprovalGettingStartedHelper {
    private static final String DEFAULT_ICON_URL = "/images/icons/statuses/generic.png";
    private final ApprovalQueueCreationHelper approvalQueueCreationHelper;
    private final ApprovalWorkflowImporterHelper approvalWorkflowImporterHelper;
    private final StatusManager statusManager;
    private final StatusCategoryManager statusCategoryManager;
    private final ResolutionManager resolutionManager;

    @Autowired
    public ApprovalGettingStartedHelperImpl(ApprovalQueueCreationHelper approvalQueueCreationHelper, ApprovalWorkflowImporterHelper approvalWorkflowImporterHelper, StatusManager statusManager, StatusCategoryManager statusCategoryManager, ResolutionManager resolutionManager) {
        this.approvalQueueCreationHelper = approvalQueueCreationHelper;
        this.approvalWorkflowImporterHelper = approvalWorkflowImporterHelper;
        this.statusManager = statusManager;
        this.statusCategoryManager = statusCategoryManager;
        this.resolutionManager = resolutionManager;
    }

    @Override
    public void importApprovalWorkflowRelatedComponent(JiraWorkflow workflow) {
        this.approvalWorkflowImporterHelper.importApprovalWorkflowRelatedComponent(workflow);
    }

    @Override
    public boolean canCreateQueue() {
        return this.approvalQueueCreationHelper.canCreateQueue();
    }

    @Override
    public Option<PremadeProjectQueueMetadata> approvedQueue(int order) {
        return this.approvalQueueCreationHelper.approvedQueue(order);
    }

    @Override
    public Option<PremadeProjectQueueMetadata> changeApprovedQueue(int order) {
        return this.approvalQueueCreationHelper.changeApprovedQueue(order);
    }

    @Override
    public void createApprovalResolutions(I18nHelper i18n, ServiceDeskProjectTemplateType serviceDeskType) {
        this.createDeclinedResolutionIfNotExist(i18n);
    }

    @Override
    public void createApprovalStatuses(I18nHelper i18n) {
        this.createDeclinedStatusIfNotExist(i18n);
    }

    private void createDeclinedResolutionIfNotExist(I18nHelper i18n) {
        if (this.isDeclinedResolutionExisting(i18n)) {
            return;
        }
        this.resolutionManager.createResolution(i18n.getText("sd.workflow.approval.resolution.declined"), i18n.getText("sd.workflow.approval.resolution.declined.description"));
    }

    private boolean isDeclinedResolutionExisting(I18nHelper i18n) {
        Resolution declinedResolution = this.resolutionManager.getResolutionByName(i18n.getText("sd.workflow.approval.resolution.declined"));
        return declinedResolution != null;
    }

    private void createDeclinedStatusIfNotExist(I18nHelper i18n) {
        String declinedStatus = i18n.getText("sd.workflow.approval.step.declined");
        if (this.isDeclinedStatusExisting(declinedStatus)) {
            return;
        }
        this.statusManager.createStatus(declinedStatus, i18n.getText("sd.workflow.imported.status"), DEFAULT_ICON_URL, this.statusCategoryManager.getStatusCategoryByKey("done"));
    }

    private boolean isDeclinedStatusExisting(String declinedStatus) {
        return this.statusManager.getStatuses().stream().anyMatch(status -> declinedStatus.equalsIgnoreCase(status.getName()));
    }
}

