/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.applink;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkManager;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class ServiceDeskAppLinkServiceImpl
implements ServiceDeskAppLinkService {
    private final ApplicationLinkService applicationLinkService;
    private final ServiceDeskAppLinkManager serviceDeskAppLinkManager;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final ApplicationLinkErrors applicationLinkErrors;

    @Autowired
    public ServiceDeskAppLinkServiceImpl(ApplicationLinkService applicationLinkService, ServiceDeskAppLinkManager serviceDeskAppLinkManager, ServiceDeskPermissions serviceDeskPermissions, ErrorResultHelper errorResultHelper, ApplicationLinkErrors applicationLinkErrors) {
        this.applicationLinkService = applicationLinkService;
        this.serviceDeskAppLinkManager = serviceDeskAppLinkManager;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.applicationLinkErrors = applicationLinkErrors;
    }

    public Either<AnError, ApplicationLink> getApplicationLink(String applicationId) {
        return this.serviceDeskAppLinkManager.getApplicationLink(applicationId);
    }

    public Either<AnError, ApplicationLink> getPrimaryApplicationLinkForType(Class<? extends ApplicationType> applicationType) {
        return Option.option((Object)this.applicationLinkService.getPrimaryApplicationLink(applicationType)).toRight(() -> this.applicationLinkErrors.MISSING_APP_LINK());
    }

    public Either<AnError, List<ApplicationLink>> getAllApplicationLinksForType(CheckedUser user, Project project, Class<? extends ApplicationType> applicationType) {
        return Steps.begin(this.canViewAppLink(user, project)).then(applink -> Either.right((Object)Lists.newArrayList((Iterable)this.applicationLinkService.getApplicationLinks(applicationType)))).yield((applink, appLinkList) -> appLinkList);
    }

    public <B> Either<AnError, B> makeGetRequest(CheckedUser user, Project project, String appLinkId, String path, BaseAppLinkResponseHandler<B> responseHandler) {
        return Steps.begin(this.canViewAppLink(user, project)).then(checkedUser -> this.serviceDeskAppLinkManager.makeGetRequest(appLinkId, path, responseHandler)).yield((checkedUser, response) -> response);
    }

    public <B> Either<AnError, B> makePostRequest(CheckedUser user, Project project, String appLinkId, String path, Object data, BaseAppLinkResponseHandler<B> responseHandler) {
        return Steps.begin(this.canViewAppLink(user, project)).then(checkedUser -> this.serviceDeskAppLinkManager.makePostRequest(appLinkId, path, data, responseHandler)).yield((checkedUser, response) -> response);
    }

    public <B> Either<AnError, B> makeGetRequestForMultipleProjects(CheckedUser user, List<Project> projectList, String appLinkId, String path, BaseAppLinkResponseHandler<B> responseHandler) {
        return Steps.begin(this.canViewMultipleAppLink(user, projectList)).then(checkedUser -> this.serviceDeskAppLinkManager.makeGetRequest(appLinkId, path, responseHandler)).yield((checkedUser, response) -> response);
    }

    public <B> Either<AnError, B> makePostRequestForMultipleProjects(CheckedUser user, List<Project> projectList, String appLinkId, String path, Object data, BaseAppLinkResponseHandler<B> responseHandler) {
        return Steps.begin(this.canViewMultipleAppLink(user, projectList)).then(checkedUser -> this.serviceDeskAppLinkManager.makePostRequest(appLinkId, path, data, responseHandler)).yield((checkedUser, response) -> response);
    }

    public <B> Either<AnError, B> makeGetRequestForSomeProjects(CheckedUser user, List<Project> projectList, String appLinkId, String path, BaseAppLinkResponseHandler<B> responseHandler) {
        return Steps.begin(this.canViewSomeAppLink(user, projectList)).then(checkedUser -> this.serviceDeskAppLinkManager.makeGetRequest(appLinkId, path, responseHandler)).yield((checkedUser, response) -> response);
    }

    public Either<AnError, Class<? extends AuthenticationProvider>> getAuthProvider(CheckedUser user, ApplicationLink link, Project project) {
        return Steps.begin(this.canViewAppLink(user, project)).then(checkedUser -> this.serviceDeskAppLinkManager.getAuthProvider(link)).yield((checkedUser, authProvider) -> authProvider);
    }

    public Boolean doesAuthTypeSupportImpersonation(Class<? extends AuthenticationProvider> authClass) {
        return this.serviceDeskAppLinkManager.doesAuthTypeSupportImpersonation(authClass);
    }

    public Either<AnError, Boolean> validateConfluenceApplicationLink(Class<? extends AuthenticationProvider> authClass, ApplicationLink appLink) {
        return Steps.begin((Either)this.serviceDeskAppLinkManager.validateAuthType(authClass)).then(auth -> this.serviceDeskAppLinkManager.validateConfluenceVersion(appLink)).yield((auth, supported) -> supported);
    }

    public Either<AnError, Boolean> isAppLinkVersionGreaterThanOrEqualTo(ApplicationLink appLink, String versionToCompare) {
        return this.serviceDeskAppLinkManager.isAppLinkVersionGreaterThanOrEqualTo(appLink, versionToCompare);
    }

    private Either<AnError, CheckedUser> canViewAppLink(CheckedUser user, Project project) {
        if (this.serviceDeskPermissions.canViewServiceDesk((SDUser)user, project)) {
            return Either.right((Object)user);
        }
        return Either.left((Object)this.applicationLinkErrors.APP_NO_PERMISSION());
    }

    private Either<AnError, CheckedUser> canViewMultipleAppLink(CheckedUser user, List<Project> projectList) {
        if (projectList.stream().anyMatch(project -> !this.serviceDeskPermissions.canViewServiceDesk((SDUser)user, (Project)project))) {
            return Either.left((Object)this.applicationLinkErrors.APP_NO_PERMISSION());
        }
        return Either.right((Object)user);
    }

    private Either<AnError, CheckedUser> canViewSomeAppLink(CheckedUser user, List<Project> projectList) {
        if (projectList.stream().anyMatch(project -> this.serviceDeskPermissions.canViewServiceDesk((SDUser)user, (Project)project))) {
            return Either.right((Object)user);
        }
        return Either.left((Object)this.applicationLinkErrors.APP_NO_PERMISSION());
    }
}

