/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.applink;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugins.rest.common.json.DefaultJaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.atlassian.plugins.rest.common.json.JsonMarshallingException;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.version.SoftwareVersion;
import com.atlassian.pocketknife.api.version.VersionKit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkManager;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Iterables;
import io.atlassian.fugue.Option;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
public class ServiceDeskAppLinkManagerImpl
implements ServiceDeskAppLinkManager {
    private static final Logger log = LoggerFactory.getLogger(ServiceDeskAppLinkManagerImpl.class);
    private static final String ACCEPT_HEADER = "Accept";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final List<Class<? extends AuthenticationProvider>> SUPPORTED_IMPERSONATION_AUTH_TYPES = Lists.newArrayList((Object[])new Class[]{TwoLeggedOAuthWithImpersonationAuthenticationProvider.class, TrustedAppsAuthenticationProvider.class});
    private static final List<Class<? extends TwoLeggedOAuthAuthenticationProvider>> SUPPORTED_OTHER_AUTH_TYPES = Lists.newArrayList((Object[])new Class[]{TwoLeggedOAuthAuthenticationProvider.class});
    private static final List<Class<? extends AuthenticationProvider>> SUPPORTED_AUTH_TYPES = ListUtils.union(SUPPORTED_IMPERSONATION_AUTH_TYPES, SUPPORTED_OTHER_AUTH_TYPES);
    private static final String SUPPORTED_CONFLUENCE_VERSION_STRING = "5.6.0";
    private final ApplicationLinkService applicationLinkService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final ApplicationLinkErrors applicationLinkErrors;
    private final ManifestRetriever manifestRetriever;

    @Autowired
    public ServiceDeskAppLinkManagerImpl(ApplicationLinkService applicationLinkService, AuthenticationConfigurationManager authenticationConfigurationManager, ApplicationLinkErrors applicationLinkErrors, ManifestRetriever manifestRetriever) {
        this.applicationLinkService = applicationLinkService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.manifestRetriever = manifestRetriever;
        this.jaxbJsonMarshaller = DefaultJaxbJsonMarshaller.builder().build();
        this.applicationLinkErrors = applicationLinkErrors;
    }

    public <T> Either<AnError, T> makePostRequest(String appLinkId, String path, Object data, BaseAppLinkResponseHandler<T> responseHandler) {
        return Steps.begin(this.buildRequestFactory(appLinkId)).then(requestFactory -> this.buildPostRequest((ApplicationLinkRequestFactory)requestFactory, path, data)).then((requestFactory, request) -> this.executeRequest((ApplicationLinkRequest)request, responseHandler)).yield((requestFactory, request, response) -> response);
    }

    public <T> Either<AnError, T> makeGetRequest(String appLinkId, String path, BaseAppLinkResponseHandler<T> responseHandler) {
        return Steps.begin(this.buildRequestFactory(appLinkId)).then(requestFactory -> this.buildGetRequest((ApplicationLinkRequestFactory)requestFactory, path)).then((requestFactory, request) -> this.executeRequest((ApplicationLinkRequest)request, responseHandler)).yield((requestFactory, request, response) -> response);
    }

    public Either<AnError, Class<? extends AuthenticationProvider>> getAuthProvider(ApplicationLink link) {
        Option firstSupportedAuthType = Iterables.findFirst(SUPPORTED_AUTH_TYPES, authClass -> this.authenticationConfigurationManager.getConfiguration(link.getId(), authClass) != null);
        return firstSupportedAuthType.toRight(() -> ((ApplicationLinkErrors)this.applicationLinkErrors).INVALID_APP_LINK_CONFIGURATION());
    }

    public Either<AnError, ApplicationLink> getApplicationLink(String applicationId) {
        return Steps.begin(this.buildApplicationId(applicationId)).then(this::getApplicationLink).yield((appId, appLink) -> appLink);
    }

    public Boolean doesAuthTypeSupportImpersonation(Class<? extends AuthenticationProvider> authClass) {
        return SUPPORTED_IMPERSONATION_AUTH_TYPES.contains(authClass);
    }

    public Either<AnError, Boolean> validateConfluenceVersion(ApplicationLink applicationLink) {
        return Steps.begin(this.getAppLinkVersion(applicationLink)).then(version -> Either.right((Object)version.isGreaterThanOrEqualTo(VersionKit.parse((String)SUPPORTED_CONFLUENCE_VERSION_STRING)))).then((version, isSupportedVersion) -> this.convertUnsupportedVersionToError((Boolean)isSupportedVersion, (SoftwareVersion)version)).yield((version, isSupportedVersion, checkedVersion) -> checkedVersion);
    }

    public Either<AnError, Class<? extends AuthenticationProvider>> validateAuthType(Class<? extends AuthenticationProvider> authClass) {
        if (SUPPORTED_AUTH_TYPES.contains(authClass)) {
            return Either.right(authClass);
        }
        return Either.left((Object)this.applicationLinkErrors.NOT_SUPPORTED_AUTHENTICATION_TYPE());
    }

    public Either<AnError, Boolean> isAppLinkVersionGreaterThanOrEqualTo(ApplicationLink appLink, String versionToCompare) {
        return Steps.begin(this.getAppLinkVersion(appLink)).then(version -> Either.right((Object)version.isGreaterThanOrEqualTo(VersionKit.parse((String)versionToCompare)))).yield((version, isGreaterThanOrEqualTo) -> isGreaterThanOrEqualTo);
    }

    private Either<AnError, Boolean> convertUnsupportedVersionToError(Boolean isSupportedVersion, SoftwareVersion version) {
        if (!isSupportedVersion.booleanValue()) {
            log.debug("This Confluence application does not meet the required minimum version to work with Service Desk. Current version: {}, Minimum required version: {}", (Object)version, (Object)SUPPORTED_CONFLUENCE_VERSION_STRING);
            return Either.left((Object)this.applicationLinkErrors.NOT_SUPPORTED_CONFLUENCE_VERSION());
        }
        return Either.right((Object)isSupportedVersion);
    }

    protected Either<AnError, SoftwareVersion> getAppLinkVersion(ApplicationLink appLink) {
        try {
            Manifest manifest = this.manifestRetriever.getManifest(appLink.getRpcUrl());
            String version = manifest.getVersion();
            if (StringUtils.isEmpty((String)version)) {
                log.debug("Version string retrieved from manifest for {} is null or empty.", (Object)appLink.getRpcUrl());
                return Either.left((Object)this.applicationLinkErrors.INTERNAL_ERROR());
            }
            return Either.right((Object)VersionKit.parse((String)version));
        }
        catch (ManifestNotFoundException e) {
            log.debug("The manifest for the application could not be found for '{}': {}", (Object)appLink.getRpcUrl(), (Object)e);
            return Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
        }
    }

    private Either<AnError, ApplicationLink> getApplicationLink(ApplicationId applicationId) {
        try {
            return Option.option((Object)this.applicationLinkService.getApplicationLink(applicationId)).toRight(() -> ((ApplicationLinkErrors)this.applicationLinkErrors).MISSING_APP_LINK());
        }
        catch (TypeNotInstalledException e) {
            return Either.left((Object)this.applicationLinkErrors.MISSING_APP_LINK());
        }
    }

    private Either<AnError, ApplicationId> buildApplicationId(String appLinkId) {
        try {
            return Either.right((Object)new ApplicationId(appLinkId));
        }
        catch (IllegalArgumentException e) {
            log.error("Application link {} was invalid.", (Object)appLinkId);
            return Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK());
        }
    }

    private Either<AnError, ApplicationLinkRequestFactory> buildRequestFactory(String appLinkId) {
        return Steps.begin(this.buildApplicationId(appLinkId)).then(this::getApplicationLink).then((applicationId, link) -> this.getRequestFactory((ApplicationLink)link)).yield((applicationId, link, requestFactory) -> requestFactory);
    }

    private <T> Either<AnError, T> executeRequest(ApplicationLinkRequest request, BaseAppLinkResponseHandler<T> responseHandler) {
        try {
            return (Either)request.execute(responseHandler);
        }
        catch (ResponseException e) {
            return responseHandler.onResponseException(e);
        }
    }

    private Either<AnError, ApplicationLinkRequest> buildGetRequest(ApplicationLinkRequestFactory requestFactory, String path) {
        try {
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, path);
            request.setHeader(CONTENT_TYPE_HEADER, "application/json");
            request.setHeader(ACCEPT_HEADER, "application/json");
            return Either.right((Object)request);
        }
        catch (CredentialsRequiredException e) {
            return Either.left((Object)this.applicationLinkErrors.MISSING_REQUEST_CREDENTIALS());
        }
    }

    private Either<AnError, ApplicationLinkRequest> buildPostRequest(ApplicationLinkRequestFactory requestFactory, String path, Object data) {
        try {
            ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.POST, path);
            request.setHeader(CONTENT_TYPE_HEADER, "application/json");
            request.setHeader(ACCEPT_HEADER, "application/json");
            request.setRequestBody(this.jaxbJsonMarshaller.marshal(data));
            return Either.right((Object)request);
        }
        catch (CredentialsRequiredException e) {
            log.error("Error building POST request, missing credentials when creating request for path: {}.", (Object)path);
            return Either.left((Object)this.applicationLinkErrors.MISSING_REQUEST_CREDENTIALS());
        }
        catch (JsonMarshallingException e) {
            log.error("Error building POST request, data could not be converted into JSON for path: {}.", (Object)path);
            return Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
        }
    }

    private Either<AnError, ApplicationLinkRequestFactory> getRequestFactory(ApplicationLink link) {
        return Steps.begin(this.getAuthProvider(link)).then(authProvider -> Option.option((Object)link.createAuthenticatedRequestFactory(authProvider)).toRight(() -> this.applicationLinkErrors.REQUEST_CREATION())).yield((authProvider, requestFactory) -> requestFactory);
    }
}

