/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.applink;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorBuilder;
import com.atlassian.pocketknife.api.commons.error.ErrorCode;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.plugins.coreui.internal.utils.HelpUrlHelper;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ApplicationLinkErrorsImpl
implements ApplicationLinkErrors {
    private final ErrorResultHelper errorHelper;
    private final I18nHelper i18nHelper;
    private final HelpUrlHelper helpUrlHelper;
    private final WebResourceUrlProvider webResourceUrlProvider;

    @Autowired
    public ApplicationLinkErrorsImpl(ErrorResultHelper errorResultHelper, I18nHelper i18nHelper, HelpUrlHelper helpUrlHelper, WebResourceUrlProvider webResourceUrlProvider) {
        this.errorHelper = errorResultHelper;
        this.i18nHelper = i18nHelper;
        this.helpUrlHelper = helpUrlHelper;
        this.webResourceUrlProvider = webResourceUrlProvider;
    }

    public AnError APP_NO_PERMISSION() {
        return this.errorHelper.forbidden403("sd.applinks.error.no.permission", new Object[0]).build();
    }

    public AnError MISSING_APP_LINK() {
        return this.errorHelper.notFound404("sd.applinks.error.missing", new Object[0]).build();
    }

    public AnError REQUEST_CREATION() {
        return this.errorHelper.badRequest400("sd.applinks.error.creation", new Object[0]).build();
    }

    public AnError INVALID_APP_LINK() {
        return this.errorHelper.internalServiceError500("sd.applinks.error.corrupt", new Object[0]).build();
    }

    public AnError INVALID_APP_LINK_CONFIGURATION() {
        return this.errorHelper.internalServiceError500("sd.applinks.config.error", new Object[0]).build();
    }

    public AnError MISSING_REQUEST_CREDENTIALS() {
        return this.errorHelper.builder("sd.knowledge.base.applink.no.credentials", new Object[0]).httpStatusCode(501).build();
    }

    public AnError FAILED_REQUEST() {
        return this.errorHelper.builder("sd.applinks.error.bad.request", new Object[0]).httpStatusCode(500).build();
    }

    public AnError GENERIC_COMMUNICATION_ERROR() {
        return this.errorHelper.builder("sd.applinks.error.generic.remote.communication", new Object[0]).httpStatusCode(500).build();
    }

    public AnError NOT_SUPPORTED_AUTHENTICATION_TYPE() {
        return this.errorHelper.builder("sd.admin.details.tab.knowledge.base.trusted.app.2lo.only", new Object[0]).httpStatusCode(501).build();
    }

    public AnError NOT_SUPPORTED_CONFLUENCE_VERSION() {
        return this.errorHelper.builder("sd.admin.details.tab.knowledge.base.cannot.old.version", new Object[0]).httpStatusCode(501).build();
    }

    public AnError CONFLUENCE_VERSION_UPGRADE_REQUIRED() {
        return this.errorHelper.builder("sd.knowledge.base.agent.issueview.panel.upgrade.confluence", new Object[0]).httpStatusCode(501).build();
    }

    public AnError INTERNAL_ERROR() {
        return this.errorHelper.internalServiceError500("sd.kb.link.error.generic.error", new Object[0]).build();
    }

    public AnError SPACE_KEY_ALREADY_EXISTS(String spaceKey) {
        return ErrorBuilder.errorBuilder().errorCode(new ErrorCode("DUPLICATE:SPACE")).addError(this.i18nHelper.getText("sd.kb.link.error.create.space.key.already.exists", spaceKey)).httpStatusCode(400).buildSingleError();
    }

    public AnError GENERATED_SPACE_KEY_ALREADY_EXISTS(String projectKey) {
        String absoluteBaseUrl = this.webResourceUrlProvider.getBaseUrl(UrlMode.ABSOLUTE);
        URI kbSettingsPageUrl = UriBuilder.fromUri((String)absoluteBaseUrl).path("servicedesk").path("admin").path(projectKey).path("confluence-kb").build(new Object[0]);
        return this.errorHelper.badRequest400("sd.kb.link.error.create.generated.space.key.already.exists", new Object[]{String.format("<a href=\"%s\" target=\"_blank\">", kbSettingsPageUrl), "</a>"}).build();
    }

    public AnError CREATE_SPACE_ERROR() {
        String kbPermissionHelpUrl = this.helpUrlHelper.getHelpPaths().getUrl("create.space.help").getUrl();
        return this.errorHelper.internalServiceError500("sd.kb.link.error.generic.create.space.error", new Object[]{String.format("<a href=\"%s\" target=\"_blank\">", kbPermissionHelpUrl), "</a>"}).build();
    }
}

