/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.announcement;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import io.atlassian.fugue.Option;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AnnouncementSettingsManager {
    private final FeatureManager featureManager;
    private final GlobalPropertyDao globalPropertyDao;
    private static final String HELP_CENTER_AGENT_ANNOUNCEMENTS_KEY = "com.atlassian.servicedesk.agent.announcement.helpcenter.enabled";
    private static final String BASE_AGENT_ANNOUNCEMENTS_ENABLED_KEY = "com.atlassian.servicedesk.agent.announcement.project.enabled";

    @Autowired
    AnnouncementSettingsManager(FeatureManager featureManager, GlobalPropertyDao globalPropertyDao) {
        this.featureManager = featureManager;
        this.globalPropertyDao = globalPropertyDao;
    }

    public void setCanAgentsManageHelpCenterAnnouncement(boolean enabled) {
        if (this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_HELP_CENTER_ANNOUNCEMENT)) {
            this.globalPropertyDao.setBooleanProperty(HELP_CENTER_AGENT_ANNOUNCEMENTS_KEY, Boolean.valueOf(enabled));
        }
    }

    public boolean canAgentsManageHelpCenterAnnouncement() {
        return this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_HELP_CENTER_ANNOUNCEMENT) && this.getProperty(HELP_CENTER_AGENT_ANNOUNCEMENTS_KEY, false);
    }

    public boolean canAgentsManagePortalAnnouncement(@Nonnull Portal portal) {
        return this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_PROJECT_ANNOUNCEMENT) && this.getProperty(this.buildKeyForPortal(portal), false);
    }

    public void setCanAgentsManagePortalAnnouncement(@Nonnull Portal portal, boolean enabled) {
        if (this.featureManager.isEnabled(SDFeatureFlags.AGENT_MANAGE_PROJECT_ANNOUNCEMENT)) {
            this.globalPropertyDao.setBooleanProperty(this.buildKeyForPortal(portal), Boolean.valueOf(enabled));
        }
    }

    private String buildKeyForPortal(Portal portal) {
        return "com.atlassian.servicedesk.agent.announcement.project.enabled." + portal.getId();
    }

    private boolean getProperty(String propertyKey, boolean valueIfNotPresent) {
        return (Boolean)Option.option((Object)this.globalPropertyDao.getBooleanProperty(propertyKey)).getOrElse((Object)valueIfNotPresent);
    }
}

