/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.announcement;

import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.api.user.UncheckedUser;
import com.atlassian.servicedesk.internal.api.errors.CommonErrors;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.feature.announcement.Announcement;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementManager;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementManagerImpl;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementService;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementSettings;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementSettingsManager;
import com.atlassian.servicedesk.internal.user.permission.ServiceDeskPermissions;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class AnnouncementServiceImpl
implements AnnouncementService {
    private final AnnouncementManager announcementManager;
    private final AnnouncementSettingsManager announcementSettingsManager;
    private final ErrorResultHelper errorResultHelper;
    private final InternalServiceDeskService internalServiceDeskService;
    private final ServiceDeskPermissions serviceDeskPermissions;
    private final CommonErrors commonErrors;
    private static final Logger logger = LoggerFactory.getLogger(AnnouncementManagerImpl.class);

    @Autowired
    public AnnouncementServiceImpl(AnnouncementManager announcementManager, AnnouncementSettingsManager announcementSettingsManager, CommonErrors commonErrors, ErrorResultHelper errorResultHelper, InternalServiceDeskService internalServiceDeskService, ServiceDeskPermissions serviceDeskPermissions) {
        this.announcementManager = announcementManager;
        this.announcementSettingsManager = announcementSettingsManager;
        this.errorResultHelper = errorResultHelper;
        this.internalServiceDeskService = internalServiceDeskService;
        this.serviceDeskPermissions = serviceDeskPermissions;
        this.commonErrors = commonErrors;
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> getHelpCenterHeaderAnnouncement(UncheckedUser user) {
        if (user.isAnonymous()) {
            return Either.right((Object)Announcement.builder().build());
        }
        return this.announcementManager.getHelpCenterHeaderAnnouncement();
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> updateHelpCenterAnnouncement(CheckedUser user, Announcement announcement) {
        if (this.canEditHelpCenterAnnouncement(user)) {
            return this.announcementManager.updateHelpCenterAnnouncement(announcement);
        }
        return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }

    @Override
    public boolean canEditHelpCenterAnnouncement(CheckedUser user) {
        if (this.serviceDeskPermissions.canAdministerJIRA((SDUser)user)) {
            return true;
        }
        return !this.internalServiceDeskService.getServiceDesksVisibleAsAgent(user, 1).isEmpty() && this.canAgentsManageHelpCenterAnnouncement();
    }

    @Override
    public boolean canAgentsManageHelpCenterAnnouncement() {
        return this.announcementSettingsManager.canAgentsManageHelpCenterAnnouncement();
    }

    @Override
    public Either<AnError, Unit> setCanAgentsManageHelpCenterAnnouncement(CheckedUser user, boolean enabled) {
        if (this.serviceDeskPermissions.canAdministerJIRA((SDUser)user)) {
            this.announcementSettingsManager.setCanAgentsManageHelpCenterAnnouncement(enabled);
            boolean updatedSetting = this.canAgentsManageHelpCenterAnnouncement();
            if (updatedSetting == enabled) {
                return Either.right((Object)Unit.Unit());
            }
            logger.warn("It appears that the announcement setting did not update correctly. Was '{}' but expected '{}'", (Object)updatedSetting, (Object)enabled);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.announcement.setting.agent.manage.update.failed", new Object[0]).build());
        }
        return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> getPortalAnnouncement(CheckedUser user, Project project, long portalId) {
        if (this.serviceDeskPermissions.canViewPortal((SDUser)user, project)) {
            return this.announcementManager.getPortalAnnouncement(portalId);
        }
        return Either.left((Object)this.commonErrors.PORTAL_NOT_AUTHORISED());
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> updatePortalAnnouncement(CheckedUser user, Project project, Portal portal, Announcement announcement) {
        if (this.canEditPortalAnnouncement(user, portal, project)) {
            return this.announcementManager.updatePortalAnnouncement(portal.getId(), announcement);
        }
        return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }

    @Override
    public boolean canEditPortalAnnouncement(CheckedUser user, Portal portal, Project project) {
        if (this.serviceDeskPermissions.canAdministerJIRA((SDUser)user) || this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return true;
        }
        return this.serviceDeskPermissions.canViewAgentView((SDUser)user, project) && this.canAgentsManagePortalAnnouncement(portal);
    }

    @Override
    public boolean canAgentsManagePortalAnnouncement(Portal portal) {
        return this.announcementSettingsManager.canAgentsManagePortalAnnouncement(portal);
    }

    @Override
    public Either<AnError, Unit> setCanAgentsManagePortalAnnouncement(CheckedUser user, Portal portal, Project project, boolean enabled) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            this.announcementSettingsManager.setCanAgentsManagePortalAnnouncement(portal, enabled);
            boolean updatedSetting = this.canAgentsManagePortalAnnouncement(portal);
            if (updatedSetting == enabled) {
                return Either.right((Object)Unit.Unit());
            }
            logger.warn("It appears that the announcement setting did not update correctly. Was '{}' but expected '{}'", (Object)updatedSetting, (Object)enabled);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.announcement.setting.agent.manage.update.failed", new Object[0]).build());
        }
        return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }

    @Override
    public Either<AnError, AnnouncementSettings> getAnnouncementSettings(CheckedUser user, Portal portal, Project project) {
        if (this.serviceDeskPermissions.canAdministerServiceDesk((SDUser)user, project)) {
            return Either.right((Object)new AnnouncementSettings(this.canAgentsManageHelpCenterAnnouncement(), this.canAgentsManagePortalAnnouncement(portal)));
        }
        return Either.left((Object)this.commonErrors.ADMINISTER_PERMISSIONS_ERROR());
    }
}

