/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.feature.announcement;

import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.persistence.GlobalPropertyDao;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.internal.feature.announcement.Announcement;
import com.atlassian.servicedesk.internal.feature.announcement.AnnouncementManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class AnnouncementManagerImpl
implements AnnouncementManager {
    private static final Logger logger = LoggerFactory.getLogger(AnnouncementManagerImpl.class);
    private static final String PORTAL_PREFIX_KEY_FORMAT = "com.atlassian.servicedesk.portal.announcement_%d";
    static final String HELP_CENTER_KEY = "com.atlassian.servicedesk.portal.announcement_shared";
    static final String HEADER = "header";
    static final String MESSAGE = "message";
    private final GlobalPropertyDao globalPropertyDao;
    private final ErrorResultHelper errorResultHelper;

    static String PORTAL_PREFIX_KEY(long portalId) {
        return String.format(PORTAL_PREFIX_KEY_FORMAT, portalId);
    }

    @Autowired
    public AnnouncementManagerImpl(GlobalPropertyDao globalPropertyDao, ErrorResultHelper errorResultHelper) {
        this.globalPropertyDao = globalPropertyDao;
        this.errorResultHelper = errorResultHelper;
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> getHelpCenterHeaderAnnouncement() {
        return this.getAnnouncement(HELP_CENTER_KEY);
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> updateHelpCenterAnnouncement(Announcement announcement) {
        return this.updateAnnouncement(HELP_CENTER_KEY, announcement);
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> getPortalAnnouncement(long portalId) {
        return this.getAnnouncement(AnnouncementManagerImpl.PORTAL_PREFIX_KEY(portalId));
    }

    @Override
    @Nonnull
    public Either<AnError, Announcement> updatePortalAnnouncement(long portalId, Announcement announcement) {
        return this.updateAnnouncement(AnnouncementManagerImpl.PORTAL_PREFIX_KEY(portalId), announcement);
    }

    private Either<AnError, Announcement> getAnnouncement(String propertyKey) {
        try {
            Announcement.Builder builder = Announcement.builder();
            String helpCenterJson = this.globalPropertyDao.getTextProperty(propertyKey);
            if (StringUtils.isNotBlank((String)helpCenterJson)) {
                JSONObject jsonObject = new JSONObject(helpCenterJson);
                builder.header(jsonObject.optString(HEADER)).message(jsonObject.optString(MESSAGE));
            }
            return Either.right((Object)builder.build());
        }
        catch (Exception e) {
            logger.error("Failed to retrieve {} announcement", (Object)propertyKey);
            logger.debug("Stacktrace", (Throwable)e);
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.announcement.get.failed", new Object[0]).build());
        }
    }

    private Either<AnError, Announcement> updateAnnouncement(String propertyKey, Announcement announcement) {
        String header = announcement.getHeaderAsText();
        String message = announcement.getMessageAsText();
        Supplier<Option> beginning = () -> {
            try {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put(HEADER, (Object)header);
                jsonObject.put(MESSAGE, (Object)message);
                this.globalPropertyDao.setTextProperty(propertyKey, jsonObject.toString());
                return Option.some((Object)((Object)JSDSuccess.success()));
            }
            catch (Exception e) {
                logger.error("Failed to update {} announcement", (Object)propertyKey);
                logger.debug("Stacktrace", (Throwable)e);
                return Option.none();
            }
        };
        Option update = Steps.begin((Option)beginning.get()).then(() -> this.getAnnouncement(propertyKey).toOption()).then((jsdSuccess, updatedAnnouncement) -> {
            if (StringUtils.equals((String)header, (String)updatedAnnouncement.getHeaderAsText()) && StringUtils.equals((String)message, (String)updatedAnnouncement.getMessageAsText())) {
                return Option.some((Object)updatedAnnouncement);
            }
            logger.warn("It appears that the {} announcement did not update correctly. Was '{}' but expected '{}'", new Object[]{propertyKey, updatedAnnouncement, announcement});
            return Option.none();
        }).yield((jsdSuccess, updatedAnnouncement, filterAnnouncement) -> filterAnnouncement);
        return update.toRight(() -> this.errorResultHelper.internalServiceError500("sd.announcement.update.failed", new Object[0]).build());
    }
}

