/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.event;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.servicedesk.internal.api.events.ChangeItemBeanUtils;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.issue.listeners.IssueInitialFieldSetStateListener;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class ChangeItemBeanUtilsImpl
implements ChangeItemBeanUtils {
    private static final Logger log = LoggerFactory.getLogger(ChangeItemBeanUtilsImpl.class);
    private final ChangeHistoryManager changeHistoryManager;
    private final IssueInitialFieldSetStateListener issueInitialFieldSetStateListener;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public ChangeItemBeanUtilsImpl(ChangeHistoryManager changeHistoryManager, IssueInitialFieldSetStateListener issueInitialFieldSetStateListener, JiraAuthenticationContext jiraAuthenticationContext) {
        this.changeHistoryManager = changeHistoryManager;
        this.issueInitialFieldSetStateListener = issueInitialFieldSetStateListener;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public FieldChangeType extractFieldChangeType(ChangeItemBean changeItemBean, Issue issue) {
        return this.extractFieldChangeTypeFromPair(this.extractChangeItemPair(changeItemBean, issue));
    }

    public boolean isChangeToAnotherValue(ChangeItemBean changeItemBean, Issue issue) {
        Pair<String, String> changePair = this.extractChangeItemPair(changeItemBean, issue);
        FieldChangeType fieldChangeType = this.extractFieldChangeTypeFromPair(changePair);
        if (fieldChangeType == FieldChangeType.SET || fieldChangeType == FieldChangeType.CLEAR) {
            return true;
        }
        return fieldChangeType == FieldChangeType.UPDATE && !Objects.equals(StringUtils.defaultString((String)((String)changePair.left())), StringUtils.defaultString((String)((String)changePair.right())));
    }

    @VisibleForTesting
    FieldChangeType extractFieldChangeTypeFromPair(Pair<String, String> changeItemPair) {
        if (StringUtils.isEmpty((String)((String)changeItemPair.left())) && StringUtils.isNotEmpty((String)((String)changeItemPair.right()))) {
            return FieldChangeType.SET;
        }
        if (StringUtils.isNotEmpty((String)((String)changeItemPair.left())) && StringUtils.isEmpty((String)((String)changeItemPair.right()))) {
            return FieldChangeType.CLEAR;
        }
        return FieldChangeType.UPDATE;
    }

    private Pair<String, String> extractChangeItemPair(ChangeItemBean changeItemBean, Issue issue) {
        Pair<String, String> comparedPair = Pair.pair((Object)StringUtils.defaultString((String)changeItemBean.getFrom()), (Object)StringUtils.defaultString((String)changeItemBean.getTo()));
        List allFieldChangeItems = this.changeHistoryManager.getChangeItemsForField(issue, changeItemBean.getField());
        if (!allFieldChangeItems.isEmpty()) {
            int changeItemIndex = allFieldChangeItems.lastIndexOf(changeItemBean);
            if (changeItemIndex == 0) {
                Pair<String, String> calculatedChangeItemPair = this.extractFieldChangeTypeSingleHistoryItemOnly(changeItemBean, issue);
                if (!Objects.equals(comparedPair, calculatedChangeItemPair)) {
                    log.debug("Found that ChangeItemBean for {} reports as an {} change on {}, however it is the first change item stored in the issue. We evaluated it to be a {} change", new Object[]{changeItemBean.getField(), comparedPair, issue.getKey(), calculatedChangeItemPair});
                }
                comparedPair = calculatedChangeItemPair;
            } else if (changeItemIndex > 0) {
                ChangeItemBean previous = (ChangeItemBean)allFieldChangeItems.get(changeItemIndex - 1);
                Pair<String, String> calculatedChangeItemPair = this.extractFieldChangeTypeFromPreviousState(previous, changeItemBean);
                if (!Objects.equals(comparedPair, calculatedChangeItemPair)) {
                    log.debug("Found that ChangeItemBean for {} reports as an {} change on {}, however we have evaluated the actual change to have been {}", new Object[]{changeItemBean.getField(), comparedPair, issue.getKey(), calculatedChangeItemPair});
                }
                comparedPair = calculatedChangeItemPair;
            }
        }
        return comparedPair;
    }

    private Pair<String, String> extractFieldChangeTypeSingleHistoryItemOnly(ChangeItemBean currentChangeItemBean, Issue issue) {
        Pair<Boolean, Option<String>> fieldSetOnIssueCreation = this.issueInitialFieldSetStateListener.isFieldSetOnIssueCreation(this.jiraAuthenticationContext.getLoggedInUser(), issue, currentChangeItemBean.getField());
        if (((Boolean)fieldSetOnIssueCreation.left()).booleanValue()) {
            return Pair.pair((Object)((Option)fieldSetOnIssueCreation.right()).getOrElse((Object)""), (Object)StringUtils.defaultString((String)currentChangeItemBean.getTo()));
        }
        return Pair.pair((Object)StringUtils.defaultString((String)currentChangeItemBean.getFrom()), (Object)StringUtils.defaultString((String)currentChangeItemBean.getTo()));
    }

    private Pair<String, String> extractFieldChangeTypeFromPreviousState(ChangeItemBean previousChangeItemBean, ChangeItemBean currentChangeItemBean) {
        if (Objects.equals(previousChangeItemBean.getTo(), currentChangeItemBean.getFrom())) {
            return Pair.pair((Object)StringUtils.defaultString((String)currentChangeItemBean.getFrom()), (Object)StringUtils.defaultString((String)currentChangeItemBean.getTo()));
        }
        log.debug("The previous change items TO state is '{}', which is different to the requested change items FROM state of '{}', will compare the previous TO with requested TO", (Object)previousChangeItemBean.getTo(), (Object)currentChangeItemBean.getFrom());
        return Pair.pair((Object)StringUtils.defaultString((String)previousChangeItemBean.getTo()), (Object)StringUtils.defaultString((String)currentChangeItemBean.getTo()));
    }
}

