/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.errors;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import com.atlassian.servicedesk.internal.api.error.ValidationErrors;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidationErrorsHelper {
    private ErrorResultHelper errorResultHelper;
    private ErrorTranslationHelper errorTranslationHelper;

    @Autowired
    public ValidationErrorsHelper(ErrorResultHelper errorResultHelper, ErrorTranslationHelper errorTranslationHelper) {
        this.errorResultHelper = errorResultHelper;
        this.errorTranslationHelper = errorTranslationHelper;
    }

    public AnError convertToAnError(CheckedUser checkUser, ValidationErrors errors) {
        return this.errorResultHelper.anError(errors.getHttpStatusCode(), "sd.rest.error.bad.request.with.extra.info", new Object[]{this.prettyPrintError(checkUser, errors)});
    }

    private String prettyPrintError(CheckedUser checkUser, ValidationErrors errors) {
        I18nHelper i18nHelper = checkUser.i18NHelper();
        Stream<String> translatedErrorMessages = errors.getErrorMessages().stream().map(message -> this.errorTranslationHelper.translateErrorMessage(message, i18nHelper));
        Stream<String> translatedFieldErrorMessages = errors.getFieldErrors().entrySet().stream().map(e -> (String)e.getKey() + " : " + this.errorTranslationHelper.translateErrorMessage((ErrorMessage)e.getValue(), i18nHelper));
        List messages = Stream.concat(translatedErrorMessages, translatedFieldErrorMessages).collect(Collectors.toList());
        return StringUtils.join(messages, (String)", ");
    }
}

