/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.errors;

import com.atlassian.annotations.nonnull.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.ErrorMessage;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.error.ErrorTranslationHelper;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ParametersAreNonnullByDefault
@ReturnValuesAreNonnullByDefault
public class ErrorTranslationHelperImpl
implements ErrorTranslationHelper {
    private final UserFactory userFactory;

    @Autowired
    public ErrorTranslationHelperImpl(UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public String translateAnError(AnError anError) {
        return this.translateAnError(anError, this.i18nHelper());
    }

    public String translateAnError(AnError anError, I18nHelper i18nHelper) {
        return this.translateErrorMessage(anError.getMessage(), i18nHelper);
    }

    public String translateErrorMessage(ErrorMessage errorMessage) {
        return this.translateErrorMessage(errorMessage, this.i18nHelper());
    }

    public String translateErrorMessage(ErrorMessage errorMessage, I18nHelper i18nHelper) {
        return (String)errorMessage.getI18n().fold(() -> ((ErrorMessage)errorMessage).getMessage(), i18n -> i18nHelper.getText(i18n.getI18nKey(), (Object)i18n.getParams()));
    }

    private I18nHelper i18nHelper() {
        return this.userFactory.getUncheckedUser().i18NHelper();
    }
}

