/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.email.replystripping;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.internal.emailreply.matcher.util.RegexUtils;
import com.atlassian.pocketknife.spi.emailreply.matcher.QuotedEmailMatcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

class MarkerBasedMatcher
implements QuotedEmailMatcher {
    private static final String MARKER_KEY = "sd.email.custommarker";
    private static final Set<String> quotedCharacters = ImmutableSet.of((Object)">", (Object)"|");
    private final LocaleManager localeManager;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final Set<String> markers;
    private boolean markerDetected = false;

    public MarkerBasedMatcher(LocaleManager localeManager, I18nHelper.BeanFactory i18nHelperFactory) {
        this.localeManager = localeManager;
        this.i18nHelperFactory = i18nHelperFactory;
        this.markers = Sets.newHashSet();
        this.initiateMarkers();
    }

    public boolean isQuotedEmail(@Nonnull List<String> textBlock) {
        boolean detected;
        if (CollectionUtils.isEmpty(textBlock)) {
            return false;
        }
        String line = textBlock.get(0);
        boolean bl = detected = this.isCustomMarkerLine(line) || this.isQuotedCustomMarkerLine(line) || this.isWikiLine(line);
        if (detected) {
            this.markerDetected = true;
        }
        return detected;
    }

    public boolean getMarkerDetected() {
        return this.markerDetected;
    }

    @VisibleForTesting
    boolean isCustomMarkerLine(String line) {
        String trimmedLine = StringUtils.trimToEmpty((String)line);
        for (String marker : this.markers) {
            if (!trimmedLine.equalsIgnoreCase(marker)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean isQuotedCustomMarkerLine(String line) {
        for (String marker : this.markers) {
            if (!StringUtils.trimToEmpty((String)line).endsWith(marker) || !this.isQuotedLine(line)) continue;
            return true;
        }
        return false;
    }

    private boolean isQuotedLine(String line) {
        String neverNullLine = StringUtils.defaultString((String)line);
        for (String quotedCharacter : quotedCharacters) {
            if (!neverNullLine.startsWith(quotedCharacter)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    boolean isWikiLine(String line) {
        if (this.markers.isEmpty()) {
            return false;
        }
        String joinedMarkers = this.markers.stream().collect(Collectors.joining("|", "(", ")"));
        Pattern wikiMarkerPattern = Pattern.compile(RegexUtils.buildRegexFromSkeleton((String)"^(\\{color:.*\\})?\\s*${0}\\s*(\\{color\\})?$", (String[])new String[]{joinedMarkers}));
        return RegexUtils.match((Pattern)wikiMarkerPattern, (String)StringUtils.trimToEmpty((String)line));
    }

    private void initiateMarkers() {
        for (Locale locale : this.localeManager.getInstalledLocales()) {
            this.markers.add(this.i18nHelperFactory.getInstance(locale).getText(MARKER_KEY));
        }
        this.markers.add("\u2014-\u2014-\u2014-\u2014");
    }
}

