/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.email.replystripping;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.mail.converters.HtmlConverter;
import com.atlassian.pocketknife.api.emailreply.EmailReplyCleaner;
import com.atlassian.servicedesk.internal.admin.EmailTrimmingMode;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.email.replystripping.EmailReplyCleanerFactory;
import com.atlassian.servicedesk.internal.email.replystripping.ServiceDeskEmailReplyCleaner;
import com.atlassian.servicedesk.internal.email.replystripping.rules.factory.EmailReplyMatcherModuleManager;
import io.atlassian.fugue.Option;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
public class EmailReplyCleanerFactoryImpl
implements EmailReplyCleanerFactory {
    private final AnalyticsService analyticsService;
    private final LocaleManager localeManager;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final EmailReplyMatcherModuleManager emailReplyMatcherModuleManager;

    @Autowired
    public EmailReplyCleanerFactoryImpl(AnalyticsService analyticsService, LocaleManager localeManager, I18nHelper.BeanFactory i18nHelperFactory, EmailReplyMatcherModuleManager emailReplyMatcherModuleManager) {
        this.analyticsService = analyticsService;
        this.localeManager = localeManager;
        this.i18nHelperFactory = i18nHelperFactory;
        this.emailReplyMatcherModuleManager = emailReplyMatcherModuleManager;
    }

    @Override
    public EmailReplyCleaner createInstance(EmailTrimmingMode emailTrimmingMode) {
        return this.createServiceDeskCleaner(emailTrimmingMode, (Option<HtmlConverter>)Option.none());
    }

    @Override
    public EmailReplyCleaner createHtmlInstance(EmailTrimmingMode emailTrimmingMode, HtmlConverter htmlConverter) {
        return this.createServiceDeskCleaner(emailTrimmingMode, (Option<HtmlConverter>)Option.some((Object)htmlConverter));
    }

    private EmailReplyCleaner createServiceDeskCleaner(EmailTrimmingMode emailTrimmingMode, Option<HtmlConverter> htmlConverterOption) {
        return new ServiceDeskEmailReplyCleaner(emailTrimmingMode, htmlConverterOption, this.analyticsService, this.localeManager, this.i18nHelperFactory, this.emailReplyMatcherModuleManager);
    }
}

