/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.util;

import com.atlassian.fugue.Either;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.project.InternalServiceDeskProjectManager;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VpOriginResolver {
    private static final String REQUEST_TYPE_NAME_PROJECT_KEY_REGEX = "^(.*) \\((.*)\\)$";
    private final RequestTypeInternalService requestTypeService;
    private final VpOriginManager vpOriginManager;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskProjectManager internalServiceDeskProjectManager;
    private final UserFactory userFactory;

    @Autowired
    public VpOriginResolver(RequestTypeInternalService requestTypeService, VpOriginManager vpOriginManager, InternalPortalService internalPortalService, InternalServiceDeskProjectManager internalServiceDeskProjectManager, UserFactory userFactory) {
        this.requestTypeService = requestTypeService;
        this.vpOriginManager = vpOriginManager;
        this.internalPortalService = internalPortalService;
        this.internalServiceDeskProjectManager = internalServiceDeskProjectManager;
        this.userFactory = userFactory;
    }

    public List<RequestType> resolveValidRequestTypes(List<QueryLiteral> rawValues, List<Portal> portals) {
        if (rawValues != null && !rawValues.isEmpty() && portals.size() > 0) {
            HashMap<Integer, Portal> idPortalMap = new HashMap<Integer, Portal>();
            for (Portal portal : portals) {
                idPortalMap.put(portal.getId(), portal);
            }
            Map<Integer, Set<String>> portalIdRequestTypes = this.getUncheckedValues(portals, rawValues);
            Set<String> requestTypeNames = portalIdRequestTypes.remove(null);
            return this.requestTypeService.loadValidRequestTypes(idPortalMap.keySet(), portalIdRequestTypes, requestTypeNames);
        }
        return Collections.emptyList();
    }

    private List<VpOrigin> searchByPortalKeyAndRequestTypeKey(String stringValue) {
        if (stringValue.matches(REQUEST_TYPE_NAME_PROJECT_KEY_REGEX)) {
            return Lists.newArrayList();
        }
        String[] split = stringValue.split("/");
        if (split.length == 2 && !split[0].isEmpty() && !split[1].isEmpty()) {
            return Lists.newArrayList((Object[])new VpOrigin[]{this.vpOriginManager.fromDbFormatUnchecked(stringValue)});
        }
        return Lists.newArrayList();
    }

    private List<VpOrigin> searchByRequestTypeNameAndProjectKey(String stringValue) {
        Pattern pattern = Pattern.compile(REQUEST_TYPE_NAME_PROJECT_KEY_REGEX);
        Matcher matcher = pattern.matcher(stringValue);
        if (matcher.matches()) {
            String requestTypeName = matcher.group(1);
            String projectKey = matcher.group(2);
            if (!requestTypeName.trim().isEmpty() && !projectKey.trim().isEmpty()) {
                io.atlassian.fugue.Either vpOriginListEither = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.internalServiceDeskProjectManager.getProjectByKeyIgnoreCase(projectKey)).then(this.internalPortalService::getPortalByProject).then((checkedUser, project, portal) -> this.vpOriginManager.getVpOriginForPortalAndRequestTypeName((Portal)portal, requestTypeName)).yield((checkedUser, project, portal, vpOrigin) -> vpOrigin);
                return (List)vpOriginListEither.fold(anError -> Lists.newArrayList(), vpOrigins -> vpOrigins);
            }
        }
        return Lists.newArrayList();
    }

    private Map<Integer, Set<String>> getUncheckedValues(List<Portal> portals, List<QueryLiteral> rawValues) {
        HashMap<String, Integer> portalKeyIDMap = new HashMap<String, Integer>();
        for (Portal portal : portals) {
            portalKeyIDMap.put(this.internalPortalService.getPortalKey(portal), portal.getId());
        }
        HashMap<Integer, Set<String>> portalIdRequestTypes = new HashMap<Integer, Set<String>>();
        HashSet<String> requestTypeNames = new HashSet<String>();
        for (QueryLiteral rawValue : rawValues) {
            String stringValue = rawValue.getStringValue();
            List<VpOrigin> vpOriginList = this.searchByPortalKeyAndRequestTypeKey(stringValue);
            if (vpOriginList.isEmpty()) {
                vpOriginList = this.searchByRequestTypeNameAndProjectKey(stringValue);
            }
            if (!vpOriginList.isEmpty()) {
                for (VpOrigin vpOrigin : vpOriginList) {
                    Integer portalId = (Integer)portalKeyIDMap.get(vpOrigin.getPortalKey());
                    if (portalId != null) {
                        HashSet<String> requestTypes = (HashSet<String>)portalIdRequestTypes.get(portalId);
                        if (requestTypes == null) {
                            requestTypes = new HashSet<String>();
                        }
                        requestTypes.add(vpOrigin.getRequestTypeKey());
                        portalIdRequestTypes.put(portalId, requestTypes);
                        continue;
                    }
                    requestTypeNames.add(rawValue.getStringValue());
                }
                continue;
            }
            requestTypeNames.add(rawValue.getStringValue());
        }
        portalIdRequestTypes.put(null, requestTypeNames);
        return portalIdRequestTypes;
    }
}

