/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.origin;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternal;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.atlassian.servicedesk.internal.feature.customer.portal.PortalInternalManager;
import com.atlassian.servicedesk.internal.feature.customer.request.requesttype.RequestTypeInternalManager;
import com.atlassian.servicedesk.internal.fields.ServiceDeskJIRAFieldService;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VpOriginManagerImpl
implements VpOriginManager {
    private static final Logger log = Logger.getLogger(VpOriginManagerImpl.class);
    private final PortalInternalManager portalManager;
    private final VpOriginCustomFieldService vpOriginCustomFieldService;
    private final ServiceDeskJIRAFieldService serviceDeskJIRAFieldService;
    private final ErrorResultHelper errorResultHelper;
    private final RequestTypeInternalManager requestTypeInternalManager;
    private final InternalPortalService internalPortalService;

    @Autowired
    public VpOriginManagerImpl(PortalInternalManager portalManager, VpOriginCustomFieldService vpOriginCustomFieldService, ServiceDeskJIRAFieldService serviceDeskJIRAFieldService, ErrorResultHelper errorResultHelper, RequestTypeInternalManager requestTypeInternalManager, InternalPortalService internalPortalService) {
        this.portalManager = portalManager;
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.serviceDeskJIRAFieldService = serviceDeskJIRAFieldService;
        this.errorResultHelper = errorResultHelper;
        this.requestTypeInternalManager = requestTypeInternalManager;
        this.internalPortalService = internalPortalService;
    }

    @Override
    public VpOrigin getVpOriginForRequestType(Portal portal, RequestType requestType) {
        String portalKey = this.portalManager.toPortalInternal(portal).getKey();
        String requestTypeKey = ((RequestTypeInternal)requestType).getKey();
        return new VpOrigin(portalKey, requestTypeKey);
    }

    @Override
    public Either<AnError, List<VpOrigin>> getVpOriginForPortalAndRequestTypeName(Portal portal, String requestTypeName) {
        List<RequestType> requestTypes = this.requestTypeInternalManager.getRequestTypeForPortalAndName(portal, requestTypeName);
        if (requestTypes.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[0]).build());
        }
        return Either.right(requestTypes.stream().map(requestType -> new VpOrigin(this.internalPortalService.getPortalKey(portal), ((RequestTypeInternal)requestType).getKey())).collect(Collectors.toList()));
    }

    @Override
    public VpOrigin fromDbFormat(String storedValue) {
        return this.stringValueToVpOrigin(storedValue, true);
    }

    @Override
    public VpOrigin fromDbFormatUnchecked(String storedValue) {
        return this.stringValueToVpOrigin(storedValue, false);
    }

    @Override
    public VpOrigin lookup(Issue issue) {
        return this.lookup(issue, true);
    }

    @Override
    public Either<AnError, VpOrigin> lookupOrError(Issue issue) {
        return Option.option((Object)this.lookup(issue)).toRight(() -> this.errorResultHelper.notFound404("sd.customerview.error.requestTypeNotFound", new Object[0]).build());
    }

    @Override
    public VpOrigin lookupUnchecked(Issue issue) {
        return this.lookup(issue, false);
    }

    private VpOrigin stringValueToVpOrigin(String storedValue, boolean validate2) {
        Validate.notNull((Object)storedValue);
        String[] split = storedValue.split("/");
        if (split.length != 2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid stored origin value %s", storedValue));
            }
            return null;
        }
        if (validate2 && !this.isValidPortal(split[0])) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Origin portal not found for '%s'.", storedValue));
            }
            return null;
        }
        return this.makeOrigin(split[0], split[1]);
    }

    private VpOrigin lookup(Issue issue, boolean validate2) {
        CustomField originCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        Object value = issue.getCustomFieldValue(originCustomField);
        if (value == null) {
            return null;
        }
        return this.stringValueToVpOrigin(value.toString(), validate2);
    }

    private boolean isValidPortal(String portalKey) {
        return this.portalManager.getPortalByKey(portalKey).isRight();
    }

    private VpOrigin makeOrigin(String key, String requestTypeKey) {
        return new VpOrigin(key, requestTypeKey);
    }

    @Override
    public String toDbFormat(VpOrigin origin) {
        return origin.toString();
    }

    @Override
    public Option<Pair<CustomField, VpOrigin>> getCustomerRequestTypeFieldInFieldLayout(Portal portalApi, Project project, RequestType requestTypeApi, IssueType issueType) {
        CustomField originCustomField = this.vpOriginCustomFieldService.getVpOriginCustomField();
        if (this.serviceDeskJIRAFieldService.isFieldPresentInAllFieldLayoutItems(project, issueType, (OrderableField)originCustomField)) {
            VpOrigin origin = this.getVpOriginForRequestType(portalApi, requestTypeApi);
            return Option.some((Object)Pair.pair((Object)originCustomField, (Object)origin));
        }
        return Option.none();
    }
}

