/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.origin;

import com.atlassian.fugue.Option;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.internal.customfields.util.IndexValuesConverter;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.requesttype.RequestType;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.customfields.origin.VpOrigin;
import com.atlassian.servicedesk.internal.customfields.origin.VpOriginManager;
import com.atlassian.servicedesk.internal.customfields.util.VpOriginResolver;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VpOriginIndexValuesConverterImpl
implements IndexValuesConverter {
    private final UserFactory userFactory;
    private final VpOriginManager vpOriginManager;
    private final InternalPortalService internalPortalService;
    private final VpOriginResolver vpOriginResolver;

    @Autowired
    public VpOriginIndexValuesConverterImpl(UserFactory userFactory, VpOriginManager vpOriginManager, InternalPortalService internalPortalService, VpOriginResolver vpOriginResolver) {
        this.userFactory = userFactory;
        this.vpOriginManager = vpOriginManager;
        this.internalPortalService = internalPortalService;
        this.vpOriginResolver = vpOriginResolver;
    }

    private Supplier<List<String>> getRawIndexValues(List<QueryLiteral> rawValues) {
        return () -> ((List)io.atlassian.fugue.Option.option((Object)rawValues).getOrElse(Collections.emptyList())).stream().map(QueryLiteral::getStringValue).collect(Collectors.toList());
    }

    @Override
    public List<String> getIndexValues(QueryCreationContext queryCreationContext, List<QueryLiteral> rawValues) {
        Pair<List<QueryLiteral>, Boolean> nonEmptyLiteralsPair = this.getNonEmptyQueryLiterals(rawValues);
        List nonEmptyLiterals = (List)nonEmptyLiteralsPair.left();
        boolean containsEmptyLiteral = (Boolean)nonEmptyLiteralsPair.right();
        io.atlassian.fugue.Option indexValuesOpt = Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option((Object)queryCreationContext)).then(context -> this.getIndexValues(context.getApplicationUser(), context.isSecurityOverriden(), nonEmptyLiterals)).yield((context, indexValues) -> indexValues);
        List result = (List)indexValuesOpt.getOr(this.getRawIndexValues(nonEmptyLiterals));
        if (containsEmptyLiteral) {
            result.add(null);
        }
        return result;
    }

    private io.atlassian.fugue.Option<List<String>> getIndexValues(ApplicationUser applicationUser, boolean overrideSecurity, List<QueryLiteral> nonEmptyQueryLiterals) {
        List portals = overrideSecurity ? this.internalPortalService.getPortalsOverrideSecurity() : (List)StepsConverters.newerOption((Option)this.userFactory.wrap(applicationUser).toOption()).map(this.internalPortalService::getCustomerVisiblePortals).getOrElse(Collections.emptyList());
        List<RequestType> requestTypes = this.vpOriginResolver.resolveValidRequestTypes(nonEmptyQueryLiterals, portals);
        ImmutableMap portalIdValueMap = Maps.uniqueIndex(portals, Portal::getId);
        List indexValues = requestTypes.stream().map(arg_0 -> this.lambda$getIndexValues$5((Map)portalIdValueMap, arg_0)).filter(indexValue -> io.atlassian.fugue.Option.option((Object)indexValue).isDefined()).collect(Collectors.toList());
        return io.atlassian.fugue.Option.option(indexValues).filter(values2 -> !values2.isEmpty());
    }

    private Pair<List<QueryLiteral>, Boolean> getNonEmptyQueryLiterals(List<QueryLiteral> queryLiterals) {
        List collect;
        return Pair.pair(collect, (Object)((collect = queryLiterals.stream().filter(queryLiteral -> null != queryLiteral.getStringValue()).collect(Collectors.toList())).size() != queryLiterals.size() ? 1 : 0));
    }

    private /* synthetic */ String lambda$getIndexValues$5(Map portalIdValueMap, RequestType requestType) {
        io.atlassian.fugue.Option vpOriginOpt = Steps.begin((io.atlassian.fugue.Option)io.atlassian.fugue.Option.option(portalIdValueMap.get((int)requestType.getPortalId()))).then(portal -> io.atlassian.fugue.Option.option((Object)this.vpOriginManager.getVpOriginForRequestType((Portal)portal, requestType))).yield((portal, vpOrigin) -> vpOrigin);
        return (String)vpOriginOpt.map(VpOrigin::toString).getOrNull();
    }
}

