/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.pocketknife.internal.customfields.util.IndexValuesConverter;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class CustomerOrganizationsIndexValuesConverter
implements IndexValuesConverter {
    private final CustomerOrganizationManager organizationManager;

    public CustomerOrganizationsIndexValuesConverter(CustomerOrganizationManager organizationManager) {
        this.organizationManager = organizationManager;
    }

    @Override
    public List<String> getIndexValues(QueryCreationContext queryCreationContext, List<QueryLiteral> queryLiterals) {
        Set<String> orgNames = queryLiterals.stream().map(QueryLiteral::getStringValue).filter(name -> name != null).collect(Collectors.toSet());
        List ids = queryLiterals.stream().map(QueryLiteral::getLongValue).filter(id -> id != null).map(String::valueOf).collect(Collectors.toList());
        Collection<CustomerOrganization> organisations = this.organizationManager.getCustomerOrganizationByNames(orgNames);
        List<String> indexValues = organisations.stream().map(org -> String.valueOf(org.getId())).collect(Collectors.toList());
        indexValues.addAll(ids);
        return indexValues;
    }
}

