/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.SupportedOperatorsValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.api.license.ServiceDeskOperationalStatus;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import com.atlassian.servicedesk.internal.feature.organization.util.CustomerOrganizationUtil;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import com.atlassian.servicedesk.internal.user.license.ServiceDeskUserLicenseService;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

public class CustomerOrganizationsClauseValidator
implements ClauseValidator {
    private final SupportedOperatorsValidator supportedOperatorsValidator;
    private final JqlOperandResolver jqlOperandResolver;
    private final ServiceDeskOperationalStatus serviceDeskOperationalStatus;
    private final I18nHelper.BeanFactory i18nFactory;
    private final CustomerOrganizationManager customerOrganizationManager;
    private final ServiceDeskUserLicenseService serviceDeskUserLicenseService;
    private final FeatureManager featureManager;

    public CustomerOrganizationsClauseValidator(SupportedOperatorsValidator supportedOperatorsValidator, JqlOperandResolver jqlOperandResolver, ServiceDeskOperationalStatus serviceDeskOperationalStatus, I18nHelper.BeanFactory i18nFactory, CustomerOrganizationManager customerOrganizationManager, ServiceDeskUserLicenseService serviceDeskUserLicenseService, FeatureManager featureManager) {
        this.supportedOperatorsValidator = supportedOperatorsValidator;
        this.jqlOperandResolver = jqlOperandResolver;
        this.serviceDeskOperationalStatus = serviceDeskOperationalStatus;
        this.i18nFactory = i18nFactory;
        this.customerOrganizationManager = customerOrganizationManager;
        this.serviceDeskUserLicenseService = serviceDeskUserLicenseService;
        this.featureManager = featureManager;
    }

    @Nonnull
    public MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        Objects.requireNonNull(terminalClause, "terminalClause");
        MessageSetImpl messageSet = new MessageSetImpl();
        if (!this.featureManager.isEnabled(SDFeatureFlags.CUSTOMER_ORG_GROUP_PARTICIPANTS)) {
            this.addErrorMessage(searcher, (MessageSet)messageSet, "sd.error.servicedesk.feature.not.enabled");
            return messageSet;
        }
        if (!this.serviceDeskOperationalStatus.isOperational()) {
            this.addErrorMessage(searcher, (MessageSet)messageSet, "sd.customer.organisation.error.function.no.license");
            return messageSet;
        }
        if (!this.serviceDeskUserLicenseService.hasValidAgentLicense(searcher)) {
            this.addErrorMessage(searcher, (MessageSet)messageSet, "sd.agent.servicedesk.error.project.nopermission");
            return messageSet;
        }
        messageSet = this.supportedOperatorsValidator.validate(searcher, terminalClause);
        if (messageSet.hasAnyErrors()) {
            return messageSet;
        }
        List queryLiterals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        this.validateNames(searcher, (MessageSet)messageSet, queryLiterals);
        this.validateIds(searcher, (MessageSet)messageSet, queryLiterals);
        return messageSet;
    }

    private void validateIds(ApplicationUser searcher, MessageSet messageSet, List<QueryLiteral> queryLiterals) {
        List<Integer> nonExistentIds = this.getNonExistentIds(queryLiterals);
        if (nonExistentIds.size() > 0) {
            this.addErrorMessage(searcher, messageSet, nonExistentIds, "sd.customer.organisation.error.function.non.id.existent");
        }
    }

    private void validateNames(ApplicationUser searcher, MessageSet messageSet, List<QueryLiteral> queryLiterals) {
        Collection<String> nonExistentOrganisations = this.getNonExistentOrganisations(queryLiterals);
        if (nonExistentOrganisations.size() > 0) {
            this.addErrorMessage(searcher, messageSet, nonExistentOrganisations, "sd.customer.organisation.error.function.non.existent");
        }
    }

    private List<Integer> getNonExistentIds(List<QueryLiteral> queryLiterals) {
        List<Integer> ids = queryLiterals.stream().map(QueryLiteral::getLongValue).filter(id -> id != null).map(Ints::checkedCast).collect(Collectors.toList());
        Collection<CustomerOrganization> organisationsById = this.customerOrganizationManager.getOrganizationsById(ids);
        List foundOrganizations = organisationsById.stream().map(organization -> organization.getId()).collect(Collectors.toList());
        ids.removeAll(foundOrganizations);
        return ids;
    }

    private void addErrorMessage(ApplicationUser applicationUser, MessageSet message, Collection nonExistentOrganisations, String i18n) {
        message.addErrorMessage(this.i18nFactory.getInstance(applicationUser).getText(i18n, StringUtils.join((Collection)nonExistentOrganisations, (String)", ")));
    }

    private void addErrorMessage(ApplicationUser applicationUser, MessageSet message, String i18n) {
        message.addErrorMessage(this.i18nFactory.getInstance(applicationUser).getText(i18n));
    }

    private Collection<String> getNonExistentOrganisations(List<QueryLiteral> values2) {
        Set<String> rawNames = values2.stream().filter(q -> q.getStringValue() != null).map(QueryLiteral::getStringValue).collect(Collectors.toSet());
        Set<String> organisationNames = this.getExistingOrganisationNames(rawNames);
        rawNames.removeAll(organisationNames);
        return rawNames;
    }

    private Set<String> getExistingOrganisationNames(Set<String> organisationNames) {
        return CustomerOrganizationUtil.transformToNames(this.customerOrganizationManager.getCustomerOrganizationByNames(organisationNames));
    }
}

