/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.organization;

import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.organization.CustomerOrganization;
import com.atlassian.servicedesk.internal.feature.organization.CustomerOrganizationManager;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class CustomerOrganizationClauseValuesGenerator
implements ClauseValuesGenerator {
    private final CustomerOrganizationManager customerOrganizationManager;

    public CustomerOrganizationClauseValuesGenerator(@Nonnull CustomerOrganizationManager customerOrganizationManager) {
        Objects.requireNonNull(customerOrganizationManager, "customerOrganizationManager");
        this.customerOrganizationManager = customerOrganizationManager;
    }

    public ClauseValuesGenerator.Results getPossibleValues(ApplicationUser searcher, String jqlClauseName, String valuePrefix, int maxNumResults) {
        Collection<CustomerOrganization> organisations = this.customerOrganizationManager.getCustomerOrganizationsByNamePrefix(valuePrefix, maxNumResults);
        return new ClauseValuesGenerator.Results(organisations.stream().map(organisation -> new ClauseValuesGenerator.Result(organisation.getName())).collect(Collectors.toList()));
    }
}

