/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.feedback;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.web.SoyWebPanel;
import com.atlassian.servicedesk.internal.api.feedback.Feedback;
import com.atlassian.servicedesk.internal.feature.feedback.RequestFeedbackInternalManager;
import io.atlassian.fugue.Option;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class RequestFeedbackWebPanel
extends SoyWebPanel {
    private static final String RATING = "rating";
    private static final String SCALE = "scale";
    private static final String RATING_DATE = "ratingDate";
    private static final String COMMENT = "comment";
    private static final String FEEDBACK_DATE_FORMAT = "dd/MMM/yyyy";
    @Autowired
    private RequestFeedbackInternalManager requestFeedbackInternalManager;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;

    public RequestFeedbackWebPanel() {
        super("com.atlassian.servicedesk:soy", "ServiceDesk.Templates.RequestFeedback.feedbackWebPanel");
    }

    @Override
    protected Map<String, Object> getTemplateParameters(Map<String, Object> context) {
        HashMap<String, Object> soyContext = new HashMap<String, Object>();
        Issue issue = this.getIssue(context);
        Option<Feedback> feedbackOption = this.requestFeedbackInternalManager.getFeedback(issue);
        if (feedbackOption.isEmpty()) {
            return soyContext;
        }
        Feedback feedback = (Feedback)feedbackOption.get();
        Integer rating = feedback.getRating();
        Integer scale = feedback.getScale();
        String ratingDateStr = this.formatFeedbackDate(feedback.getRatingDate());
        String comment = (String)feedback.getComment().getOrElse((Object)"");
        soyContext.put(RATING, rating);
        soyContext.put(SCALE, scale);
        soyContext.put(RATING_DATE, ratingDateStr);
        soyContext.put(COMMENT, comment);
        return soyContext;
    }

    private String formatFeedbackDate(Date date) {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return new SimpleDateFormat(FEEDBACK_DATE_FORMAT).format(date);
        }
        DateTimeFormatter dateFormatter = this.dateTimeFormatter.forUser(loggedInUser).withStyle(DateTimeStyle.RELATIVE);
        return dateFormatter.format(date);
    }
}

