/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields.feedback;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldException;
import com.atlassian.pocketknife.api.customfields.service.CustomFieldMetadata;
import com.atlassian.pocketknife.api.customfields.service.GlobalCustomFieldService;
import com.atlassian.pocketknife.api.logging.Log;
import com.atlassian.servicedesk.internal.api.customfields.feedback.RequestFeedbackDateCFManager;
import io.atlassian.fugue.Option;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class RequestFeedbackDateCFManagerImpl
implements RequestFeedbackDateCFManager {
    protected final Log log = Log.with(this.getClass());
    private final CustomFieldMetadata customFieldMetaData = CustomFieldMetadata.builder().fieldName("sd.request.feedback.date.name").fieldDescription("sd.request.feedback.date.desc").fieldType("com.atlassian.servicedesk:sd-request-feedback-date").fieldSearcher("com.atlassian.servicedesk:sd-request-feedback-date-searcher").lockField(true).build();
    @Autowired
    private GlobalCustomFieldService globalCustomFieldService;

    public Option<CustomField> getOrCreateRequestFeedbackDateCF() {
        try {
            CustomField feedbackDateCF = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
            return Option.some((Object)feedbackDateCF);
        }
        catch (CustomFieldException e) {
            this.log.error(e.getMessage(), new Object[0]);
            return Option.none();
        }
    }

    public Option<Date> getRequestFeedbackDate(Issue issue) {
        CustomField feedbackDateCF = this.globalCustomFieldService.getGlobalCustomField(this.customFieldMetaData);
        Object value = feedbackDateCF.getValue(issue);
        if (value != null) {
            return Option.some((Object)((Date)value));
        }
        return Option.none();
    }
}

