/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customfields;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.web.bean.BulkEditBean;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.feature.customer.portal.InternalPortalService;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SDCustomfieldBulkEditSecurityHelper {
    private final UserFactory userFactory;
    private final InternalPortalService internalPortalService;
    private final InternalServiceDeskService internalServiceDeskService;

    @Autowired
    public SDCustomfieldBulkEditSecurityHelper(UserFactory userFactory, InternalPortalService internalPortalService, InternalServiceDeskService internalServiceDeskService) {
        this.userFactory = userFactory;
        this.internalPortalService = internalPortalService;
        this.internalServiceDeskService = internalServiceDeskService;
    }

    public Option<String> isAllowedForSDBulkEdit(BulkEditBean bulkEditBean) {
        Project project = bulkEditBean.getSingleProject();
        Option optUser = StepsConverters.newerOption((com.atlassian.fugue.Option)this.userFactory.getCheckedUser().toOption());
        if (optUser.isEmpty()) {
            return Option.some((Object)"bulk.edit.requesttype.anonymoususer");
        }
        if (this.internalPortalService.getPortalByProject((CheckedUser)optUser.get(), project).toOption().isEmpty() || !this.internalServiceDeskService.isServiceDeskEnabledForUser((CheckedUser)optUser.get(), project)) {
            return Option.some((Object)"bulk.edit.unavailable.servicedesknotenable");
        }
        return Option.none();
    }
}

