/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customergroup;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.customergroup.CustomerGroup;
import com.atlassian.servicedesk.internal.api.customergroup.CustomerGroupService;
import com.atlassian.servicedesk.internal.spi.customergroup.CustomerGroupSPI;
import com.atlassian.servicedesk.internal.spi.customergroup.CustomerGroupSPIRegistry;
import com.atlassian.servicedesk.internal.spi.permission.security.CustomerInvolvedType;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserProviderRegistry;
import com.atlassian.servicedesk.internal.spi.permission.security.RequestAccessUserStrategy;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerGroupServiceImpl
implements CustomerGroupService,
CustomerGroupSPIRegistry,
RequestAccessUserStrategy {
    private CustomerGroupSPI implementation;
    private final UserFactory userFactory;

    @Autowired
    public CustomerGroupServiceImpl(RequestAccessUserProviderRegistry requestAccessUserProviderRegistry, UserFactory userFactory) {
        this.userFactory = userFactory;
    }

    public Either<AnError, List<CustomerGroup>> search(CheckedUser user, Issue issue, String queryString) {
        if (this.implementation == null) {
            return Either.right(Collections.emptyList());
        }
        return this.implementation.search(user, issue, queryString);
    }

    public Either<AnError, Set<CustomerGroup>> getAllForIssue(Issue issue) {
        if (this.implementation == null) {
            return Either.right(Collections.emptySet());
        }
        return this.implementation.getAllFromIssue(issue);
    }

    public Either<AnError, Set<CustomerGroup>> getCustomerGroupsForUser(CheckedUser user) {
        if (this.implementation == null) {
            return Either.right(Collections.emptySet());
        }
        return this.implementation.getGroups(user);
    }

    public Either<AnError, Unit> addToIssue(Issue issue, Set<CustomerGroup> customerGroups) {
        if (this.implementation == null) {
            return Either.right((Object)Unit.Unit());
        }
        return this.implementation.addToIssue(issue, customerGroups);
    }

    public Either<AnError, Unit> removeFromIssue(Issue issue, Set<CustomerGroup> customerGroups) {
        if (this.implementation == null) {
            return Either.right((Object)Unit.Unit());
        }
        return this.implementation.removeFromIssue(issue, customerGroups);
    }

    public CustomerInvolvedType getType() {
        return CustomerInvolvedType.CUSTOMER_GROUP;
    }

    public List<CheckedUser> getUsers(@Nonnull Issue issue) {
        if (this.implementation == null) {
            return Collections.emptyList();
        }
        return this.implementation.getUsers(issue);
    }

    public boolean match(ApplicationUser user, Issue issue) {
        if (this.implementation == null) {
            return false;
        }
        return (Boolean)this.userFactory.wrap(user).map(checkedUser -> this.implementation.match(checkedUser, issue)).getOrElse((Object)false);
    }

    public void register(CustomerGroupSPI customerGroupSPI) {
        if (this.implementation != null) {
            throw new RuntimeException("Attempted to register an SPI when there was already one registered previously");
        }
        this.implementation = customerGroupSPI;
    }

    public void unregister(CustomerGroupSPI customerGroupSPI) {
        if (this.implementation != customerGroupSPI) {
            throw new RuntimeException("Attempted to unregister an SPI that hasn't previously been registered");
        }
        this.implementation = null;
    }
}

