/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer.context.urimatching;

import com.atlassian.servicedesk.internal.customer.context.urimatching.UriMatch;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UriMatcher {
    private final ImmutableList<UriMatch> matches;

    public static UriMatcher emptyMatcher() {
        return new UriMatcher((ImmutableList<UriMatch>)ImmutableList.of());
    }

    public UriMatcher(ImmutableList<UriMatch> matches) {
        this.matches = (ImmutableList)Preconditions.checkNotNull(matches);
    }

    public Decision matches(String requestPath) {
        try {
            return this.matchImpl(requestPath);
        }
        catch (Exception ignored) {
            return Decision.ABSTAINED;
        }
    }

    private Decision matchImpl(String requestPath) {
        if (StringUtils.isEmpty((String)requestPath)) {
            return Decision.ABSTAINED;
        }
        for (UriMatch uriMatch : this.matches) {
            String uriStartsWith = uriMatch.getUriStartsWith();
            boolean startsWith = requestPath.startsWith(uriStartsWith);
            if (!startsWith) continue;
            boolean blacklist = !uriMatch.isWhiteList();
            String pathAfterStart = StringUtils.substring((String)requestPath, (int)uriStartsWith.length());
            for (Pattern uriPattern : uriMatch.getUriMatchPatterns()) {
                if (!uriPattern.matcher(pathAfterStart).matches()) continue;
                if (blacklist) {
                    return Decision.DENIED;
                }
                return Decision.GRANTED;
            }
        }
        return Decision.ABSTAINED;
    }

    public static enum Decision {
        GRANTED,
        DENIED,
        ABSTAINED;

    }
}

