/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.customer.context.urimatching;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class UriMatch {
    private String uriStartsWith;
    private boolean whiteList = true;
    private List<Pattern> uriMatchPatterns;

    private UriMatch(String uriStartsWith, boolean whiteList, Iterable<Pattern> uriMatchPatterns) {
        this.uriStartsWith = (String)Preconditions.checkNotNull((Object)uriStartsWith);
        this.whiteList = whiteList;
        this.uriMatchPatterns = ImmutableList.copyOf(uriMatchPatterns);
    }

    public String getUriStartsWith() {
        return this.uriStartsWith;
    }

    public boolean isWhiteList() {
        return this.whiteList;
    }

    public List<Pattern> getUriMatchPatterns() {
        return this.uriMatchPatterns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(UriMatch data) {
        return new Builder(data);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UriMatch that = (UriMatch)o;
        return Objects.equal((Object)this.uriStartsWith, (Object)that.uriStartsWith) && Objects.equal((Object)this.whiteList, (Object)that.whiteList) && Objects.equal(this.uriMatchPatterns, that.uriMatchPatterns);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.uriStartsWith, this.whiteList, this.uriMatchPatterns});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("uriStartsWith", (Object)this.uriStartsWith).add("whiteList", this.whiteList).add("uriMatchPatterns", this.uriMatchPatterns).toString();
    }

    public static final class Builder {
        private String uriStartsWith;
        private boolean whiteList = true;
        private List<Pattern> uriMatchPatterns = Lists.newArrayList();

        private Builder() {
        }

        private Builder(UriMatch initialData) {
            this.uriStartsWith = initialData.uriStartsWith;
            this.whiteList = initialData.whiteList;
            this.uriMatchPatterns = initialData.uriMatchPatterns;
        }

        public Builder startsWith(String uriStartsWith) {
            this.uriStartsWith = uriStartsWith;
            return this;
        }

        public Builder setBlackList() {
            this.whiteList = false;
            return this;
        }

        public Builder setPatterns(List<Pattern> uriMatchPatterns) {
            this.uriMatchPatterns = uriMatchPatterns;
            return this;
        }

        public Builder addPattern(Pattern uriMatchPattern) {
            this.uriMatchPatterns.add(uriMatchPattern);
            return this;
        }

        public Builder addPattern(String uriMatchPattern) {
            this.uriMatchPatterns.add(Pattern.compile(uriMatchPattern));
            return this;
        }

        public UriMatch build() {
            return new UriMatch(this.uriStartsWith, this.whiteList, this.uriMatchPatterns);
        }
    }
}

