/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.search;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseArticle;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.responses.ConfluenceKBArticleResponse;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.responses.ConfluenceKBSearchResultResponse;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.BaseConfluenceAppLinkResponseHandler;
import com.atlassian.servicedesk.workinprogressapi.kb.KnowledgeBaseArticle;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.ParametersAreNonnullByDefault;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.util.Assert;

@ParametersAreNonnullByDefault
public class ConfluenceSearchAppLinkResponseHandler
extends BaseConfluenceAppLinkResponseHandler<List<KnowledgeBaseArticle>> {
    private final ConfluenceKnowledgeBaseLink confluenceKBLink;
    private final String path;
    private static final Pattern SPACE_KEY_FROM_URL_PATTERN = Pattern.compile(".*\\/display\\/(.*)");

    public ConfluenceSearchAppLinkResponseHandler(ConfluenceKnowledgeBaseLink confluenceKBLink, String path, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors, ApplicationLinkErrors applicationLinkErrors) {
        super(errorResultHelper, confluenceKbErrors, applicationLinkErrors);
        Assert.notNull((Object)confluenceKBLink);
        Assert.notNull((Object)path);
        this.confluenceKBLink = confluenceKBLink;
        this.path = path;
    }

    public Either<AnError, List<KnowledgeBaseArticle>> onSuccess(String responseBody) {
        if (responseBody == null) {
            log.debug("Confluence search returned an empty response.");
            return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_COMMUNICATION_ERROR());
        }
        try {
            ConfluenceKBSearchResultResponse confluenceKbResult = (ConfluenceKBSearchResultResponse)new ObjectMapper().readValue(responseBody, ConfluenceKBSearchResultResponse.class);
            ArrayList articles = Lists.newArrayList();
            List<ConfluenceKBArticleResponse> results = confluenceKbResult.getResults();
            if (results == null) {
                return Either.right((Object)articles);
            }
            for (ConfluenceKBArticleResponse article : results) {
                Either<AnError, String> remoteUrlEither = this.getRemoteUrl(this.confluenceKBLink, article.getId());
                if (remoteUrlEither.isLeft()) {
                    return Either.left((Object)remoteUrlEither.left().get());
                }
                String remoteUrl = (String)remoteUrlEither.right().get();
                String spaceKey = this.getSpaceKey(article.getSearchResultContainer().getUrl());
                ConfluenceKnowledgeBaseArticle confluenceKnowledgeBaseArticle = new ConfluenceKnowledgeBaseArticle(article.getTitle(), article.getBodyTextHighlights(), remoteUrl, article.getId(), spaceKey, this.confluenceKBLink.getApplicationId());
                articles.add(confluenceKnowledgeBaseArticle);
            }
            return Either.right((Object)articles);
        }
        catch (IOException | ClassCastException ex) {
            log.debug("Failed to complete operation with the following exception " + ex.getMessage());
            return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_COMMUNICATION_ERROR());
        }
    }

    private String getSpaceKey(String url) {
        Matcher m = SPACE_KEY_FROM_URL_PATTERN.matcher(url);
        return m.find() ? m.group(1) : "";
    }
}

