/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.responses;

import com.atlassian.fugue.Either;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.rest.responses.kb.ConfluenceKBSpaceResponse;
import io.atlassian.fugue.Option;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class ConfluenceKBCreateSpaceResponseHandler
extends BaseAppLinkResponseHandler<ConfluenceKBSpaceResponse> {
    public ConfluenceKBCreateSpaceResponseHandler(ApplicationLinkErrors applicationLinkErrors, ErrorResultHelper errorResultHelper) {
        super(applicationLinkErrors, errorResultHelper);
    }

    public io.atlassian.fugue.Either<AnError, ConfluenceKBSpaceResponse> onCredentialError(String responseBody) {
        log.error("Unsupported or misconfigured application link authentication settings, check the settings in application links: {}", (Object)responseBody);
        return io.atlassian.fugue.Either.left((Object)this.applicationLinkErrors.INVALID_APP_LINK_CONFIGURATION());
    }

    public io.atlassian.fugue.Either<AnError, ConfluenceKBSpaceResponse> onError(String responseBody, int statusCode) {
        try {
            Option jsonObjectOption = this.toJsonObject(responseBody);
            if (jsonObjectOption.isEmpty()) {
                log.debug("Empty response body returned when trying to create a Confluence space.");
                return io.atlassian.fugue.Either.left((Object)this.applicationLinkErrors.GENERIC_COMMUNICATION_ERROR());
            }
            JsonNode jsonObject = (JsonNode)jsonObjectOption.get();
            if (statusCode == 400 && jsonObject.has("errorType") && jsonObject.get("errorType").asText().equals("DUPLICATED:SPACE")) {
                String spaceKey = "";
                if (jsonObject.has("errorData")) {
                    spaceKey = jsonObject.get("errorData").getTextValue();
                }
                log.debug("Confluence space creation failed. A Confluence space already exists with the key {}", (Object)spaceKey);
                return io.atlassian.fugue.Either.left((Object)this.applicationLinkErrors.SPACE_KEY_ALREADY_EXISTS(spaceKey));
            }
        }
        catch (Exception e) {
            log.error("Error parsing results from knowledge base server", (Throwable)e);
            return StepsConverters.newerEither((Either)this.errorResultHelper.error(500, "sd.knowledge.base.results.parse.error", new Object[0]));
        }
        return io.atlassian.fugue.Either.left((Object)this.applicationLinkErrors.CREATE_SPACE_ERROR());
    }

    public io.atlassian.fugue.Either<AnError, ConfluenceKBSpaceResponse> onSuccess(String responseBody) {
        Option jsonObjectOption = this.toJsonObject(responseBody);
        JsonNode jsonNode = (JsonNode)jsonObjectOption.getOr(() -> {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.createObjectNode();
        });
        ConfluenceKBSpaceResponse confluenceSpace = new ConfluenceKBSpaceResponse((String)this.getStringValue(jsonNode.get("key")).getOrElse((Object)""), (String)this.getStringValue(jsonNode.get("name")).getOrElse((Object)""), (String)this.getStringValue(jsonNode.get("url")).getOrElse((Object)""));
        return io.atlassian.fugue.Either.right((Object)confluenceSpace);
    }

    private Option<String> getStringValue(JsonNode jsonNode) {
        return Option.option((Object)jsonNode).map(JsonNode::getTextValue);
    }
}

