/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.search.BaseConfluenceAppLinkResponseHandler;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.codehaus.jackson.JsonNode;

public abstract class ConfluencePermissionsAppLinkResponseHandler<T>
extends BaseConfluenceAppLinkResponseHandler<T> {
    protected String path;

    public ConfluencePermissionsAppLinkResponseHandler(String path, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors, ApplicationLinkErrors applicationLinkErrors) {
        super(errorResultHelper, confluenceKbErrors, applicationLinkErrors);
        this.path = path;
    }

    @Override
    public Either<AnError, T> onError(String responseBody, int statusCode) {
        try {
            Option jsonObjectOption = this.toJsonObject(responseBody);
            if (jsonObjectOption.isEmpty()) {
                log.warn("Could not contact the Confluence KB plugin. Check that the Confluence Knowledge Base plugin is installed and enabled.");
                return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_KB_PLUGIN_GENERIC_ERROR());
            }
            JsonNode jsonObject = (JsonNode)jsonObjectOption.get();
            if (jsonObject.has("status-code") && jsonObject.get("status-code").asInt() == 404) {
                log.warn("Confluence KB plugin present but the endpoint is not. Check that the Confluence Knowledge Base plugin is at least version 2.0.5.");
                return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_KB_PLUGIN_GENERIC_ERROR());
            }
            String errorMessage = jsonObject.has("errorMessage") ? jsonObject.get("errorMessage").getTextValue() : (jsonObject.has("message") ? jsonObject.get("message").getTextValue() : jsonObject.toString());
            log.warn("There was an error communicating with Confluence: {}", (Object)errorMessage);
            AnError error = this.confluenceKBErrors.CONFLUENCE_KB_PLUGIN_GENERIC_ERROR();
            return Either.left((Object)error);
        }
        catch (Exception e) {
            log.warn("Confluence is up but something's gone wrong and produced the following exception: {}", (Object)e.getMessage());
            return Either.left((Object)this.confluenceKBErrors.CONFLUENCE_KB_PLUGIN_GENERIC_ERROR());
        }
    }
}

