/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions;

import com.atlassian.fugue.Either;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.JSDSuccess;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsEvent;
import com.atlassian.servicedesk.internal.api.analytics.AnalyticsService;
import com.atlassian.servicedesk.internal.api.applink.ApplicationLinkErrors;
import com.atlassian.servicedesk.internal.api.applink.BaseAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.api.feature.applink.ServiceDeskAppLinkService;
import com.atlassian.servicedesk.internal.api.feature.servicedesk.InternalServiceDeskService;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.ConfluenceKnowledgeBaseManager;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.errors.ConfluenceKBErrors;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceFullPermissionsAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceGlobalPermissionsAppLinkResponseHandler;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBGlobalPermissions;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBGlobalPermissionsPayload;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBPermissionService;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBPermissions;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBSpacePermissions;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.ConfluenceKBSpacePermissionsPayload;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.permissions.analytics.ConfluencePermissionFixAnalyticEvent;
import com.atlassian.servicedesk.internal.confluenceknowledgebase.responses.ConfluenceKBViewResponse;
import com.atlassian.servicedesk.internal.featureflag.SDFeatureFlags;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConfluenceKBPermissionServiceImpl
implements ConfluenceKBPermissionService {
    private final String CONFLUENCE_PERMISSIONS_ENDPOINT_PREFIX = "/rest/knowledge-base/1.0/permissions";
    private final String CONFLUENCE_SPACE_UNLICENSED_VIEW_POST_ENDPOINT = "/rest/knowledge-base/1.0/permissions/space/unlicensedview";
    private final String CONFLUENCE_GLOBAL_UNLICENSED_ACCESS_POST_ENDPOINT = "/rest/knowledge-base/1.0/permissions/global/unlicensedaccess";
    private final String CONFLUENCE_SPACE_PERMISSIONS_GET_ENDPOINT_PREFIX = "/rest/knowledge-base/1.0/permissions?spaceKey=";
    private Logger logger = LoggerFactory.getLogger(ConfluenceKBPermissionServiceImpl.class);
    private ServiceDeskAppLinkService sdApplinkService;
    private ConfluenceKnowledgeBaseManager kbManager;
    private InternalServiceDeskService serviceDeskService;
    private ServiceDeskPermissionService sdPermissionService;
    private FeatureManager featureManager;
    private ApplicationProperties applicationProperties;
    private AnalyticsService analyticsService;
    private ErrorResultHelper errorResultHelper;
    private ConfluenceKBErrors confluenceKbErrors;
    private ApplicationLinkErrors applicationLinkErrors;

    @Autowired
    public ConfluenceKBPermissionServiceImpl(ServiceDeskAppLinkService sdApplinkService, ConfluenceKnowledgeBaseManager kbManager, InternalServiceDeskService serviceDeskService, ServiceDeskPermissionService sdPermissionService, FeatureManager featureManager, ApplicationProperties applicationProperties, AnalyticsService analyticsService, ErrorResultHelper errorResultHelper, ConfluenceKBErrors confluenceKbErrors, ApplicationLinkErrors applicationLinkErrors) {
        this.sdApplinkService = sdApplinkService;
        this.kbManager = kbManager;
        this.serviceDeskService = serviceDeskService;
        this.sdPermissionService = sdPermissionService;
        this.featureManager = featureManager;
        this.applicationProperties = applicationProperties;
        this.analyticsService = analyticsService;
        this.errorResultHelper = errorResultHelper;
        this.confluenceKbErrors = confluenceKbErrors;
        this.applicationLinkErrors = applicationLinkErrors;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ConfluenceKBViewResponse> getConfluenceViewStatus(CheckedUser user, Project project) {
        return Steps.begin(this.validateThenGetServiceDesk(user, project)).then(sd -> this.kbManager.getKBLink((ServiceDesk)sd)).then((sd, kbLink) -> this.makePermissionsGetRequestForKbLink(user, project, (ConfluenceKnowledgeBaseLink)kbLink)).yield((sd, kbLink, permissions) -> this.calculateKBViewResponse((ConfluenceKBPermissions)permissions));
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ConfluenceKBViewResponse> validateAndFixConfluenceViewStatus(CheckedUser user, Project project, ConfluenceKBViewResponse confluenceKBViewResponse) {
        if (!this.featureManager.isEnabled(SDFeatureFlags.CONFLUENCE_KB_ANONYMOUS_MAGIC_PERMISSION_FIX)) {
            return io.atlassian.fugue.Either.right((Object)confluenceKBViewResponse);
        }
        if (confluenceKBViewResponse.isAnonymousViewEnabled() && !confluenceKBViewResponse.isUnlicensedViewPermissionEnabled()) {
            this.logger.info("Attempting to fix Confluence {} space permissions by enabling unlicensed permission when anonymous permission is enabled", (Object)confluenceKBViewResponse.getSpaceKey());
            ConfluencePermissionFixAnalyticEvent confluencePermissionFixAnalyticEvent = new ConfluencePermissionFixAnalyticEvent(project.getId());
            this.analyticsService.fireAnalyticsEvent((AnalyticsEvent)confluencePermissionFixAnalyticEvent);
            return this.enableUnlicensedAuthenticatedView(user, project);
        }
        return io.atlassian.fugue.Either.right((Object)confluenceKBViewResponse);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ConfluenceKBViewResponse> enableUnlicensedAuthenticatedView(CheckedUser user, Project project) {
        return this.changeUnlicensedAccessViewPermission(user, project, true);
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ConfluenceKBViewResponse> disableUnlicensedAuthenticatedView(CheckedUser user, Project project) {
        return this.changeUnlicensedAccessViewPermission(user, project, false);
    }

    private io.atlassian.fugue.Either<AnError, ConfluenceKBViewResponse> changeUnlicensedAccessViewPermission(CheckedUser user, Project project, boolean shouldEnableUnlicensedAccessView) {
        return Steps.begin(this.validateThenGetServiceDesk(user, project)).then(sd -> this.kbManager.getKBLink((ServiceDesk)sd)).then((sd, kbLink) -> this.makeUnlicensedViewPostRequestForKbLink(user, project, (ConfluenceKnowledgeBaseLink)kbLink, shouldEnableUnlicensedAccessView)).yield((sd, kbLink, permissions) -> this.calculateKBViewResponse((ConfluenceKBPermissions)permissions));
    }

    private ConfluenceKBViewResponse calculateKBViewResponse(ConfluenceKBPermissions permissions) {
        boolean canViewAsAnon = permissions.getGlobalPermissions().isAnonymousAccessEnabled() && permissions.getSpacePermissions().isAnonymousViewPermissionEnabled();
        boolean canViewAsUnlicensed = permissions.getGlobalPermissions().isUnlicensedAuthenticatedAccessEnabled() && permissions.getSpacePermissions().isUnlicensedViewPermissionEnabled();
        String spaceKey = permissions.getSpacePermissions().getSpaceKey();
        return new ConfluenceKBViewResponse(spaceKey, canViewAsUnlicensed, canViewAsAnon);
    }

    private io.atlassian.fugue.Either<AnError, ConfluenceKBPermissions> makeUnlicensedViewPostRequestForKbLink(CheckedUser user, Project project, ConfluenceKnowledgeBaseLink kbLink, boolean enableUnlicensedView) {
        String spaceKey = kbLink.getSpaceKey();
        String applinkId = kbLink.getApplicationId();
        ConfluenceKBSpacePermissionsPayload payload = new ConfluenceKBSpacePermissionsPayload(spaceKey, enableUnlicensedView);
        io.atlassian.fugue.Either result = this.sdApplinkService.makePostRequest(user, project, applinkId, "/rest/knowledge-base/1.0/permissions/space/unlicensedview", (Object)payload, (BaseAppLinkResponseHandler)new ConfluenceFullPermissionsAppLinkResponseHandler("/rest/knowledge-base/1.0/permissions/space/unlicensedview", this.errorResultHelper, this.confluenceKbErrors, this.applicationLinkErrors));
        if (enableUnlicensedView && result.isRight() && !((ConfluenceKBPermissions)result.right().get()).getGlobalPermissions().isUnlicensedAuthenticatedAccessEnabled()) {
            ConfluenceKBGlobalPermissionsPayload globalPayload = new ConfluenceKBGlobalPermissionsPayload(true);
            ConfluenceGlobalPermissionsAppLinkResponseHandler appLinkResponseHandler = new ConfluenceGlobalPermissionsAppLinkResponseHandler("/rest/knowledge-base/1.0/permissions/global/unlicensedaccess", this.errorResultHelper, this.confluenceKbErrors, this.applicationLinkErrors);
            io.atlassian.fugue.Either globalPostRequestEither = this.sdApplinkService.makePostRequest(user, project, applinkId, "/rest/knowledge-base/1.0/permissions/global/unlicensedaccess", (Object)globalPayload, (BaseAppLinkResponseHandler)appLinkResponseHandler);
            if (globalPostRequestEither.isLeft()) {
                result = io.atlassian.fugue.Either.left((Object)globalPostRequestEither.left().get());
            } else {
                ConfluenceKBSpacePermissions spacePermissions = ((ConfluenceKBPermissions)result.right().get()).getSpacePermissions();
                ConfluenceKBPermissions confluenceKBPermissions = new ConfluenceKBPermissions(spacePermissions, (ConfluenceKBGlobalPermissions)globalPostRequestEither.right().get());
                result = io.atlassian.fugue.Either.right((Object)confluenceKBPermissions);
            }
        }
        return result;
    }

    private io.atlassian.fugue.Either<AnError, ConfluenceKBPermissions> makePermissionsGetRequestForKbLink(CheckedUser user, Project project, ConfluenceKnowledgeBaseLink kbLink) {
        String spaceKey = kbLink.getSpaceKey();
        try {
            spaceKey = URLEncoder.encode(spaceKey, this.applicationProperties.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("Unsupported encoding type in JIRA application properties: {}", (Object)this.applicationProperties.getEncoding());
            return io.atlassian.fugue.Either.left((Object)this.confluenceKbErrors.INVALID_JIRA_CONFIG());
        }
        String applinkId = kbLink.getApplicationId();
        String path = "/rest/knowledge-base/1.0/permissions?spaceKey=" + spaceKey;
        return this.sdApplinkService.makeGetRequest(user, project, applinkId, path, (BaseAppLinkResponseHandler)new ConfluenceFullPermissionsAppLinkResponseHandler(path, this.errorResultHelper, this.confluenceKbErrors, this.applicationLinkErrors));
    }

    private io.atlassian.fugue.Either<AnError, ServiceDesk> validateThenGetServiceDesk(CheckedUser user, Project project) {
        return Steps.begin((io.atlassian.fugue.Either)this.serviceDeskService.getServiceDeskForProject(user, project, false)).then(sd -> this.verifyAdminAgent(user, (ServiceDesk)sd)).yield((sd, success) -> sd);
    }

    private io.atlassian.fugue.Either<AnError, JSDSuccess> verifyAdminAgent(CheckedUser user, ServiceDesk serviceDesk) {
        io.atlassian.fugue.Either permissionEither = StepsConverters.newerEither((Either)this.sdPermissionService.isAdminAgent(user.forJIRA(), serviceDesk));
        if (permissionEither.isLeft()) {
            return permissionEither.map(ignored -> JSDSuccess.success());
        }
        boolean isAgentAdmin = (Boolean)permissionEither.right().get();
        if (isAgentAdmin) {
            return io.atlassian.fugue.Either.right((Object)((Object)JSDSuccess.success()));
        }
        return io.atlassian.fugue.Either.left((Object)this.confluenceKbErrors.CONFLUENCE_AGENT_ADMIN_ERROR());
    }
}

